<?php

namespace App\Events;

use App\Models\Message;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class MessageSent implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels;

    public $message;

    public function __construct(Message $message)
    {
        $this->message = $message;
    }

    public function broadcastOn()
    {
 return new PrivateChannel('chat.' . $this->message->conversation_id);
        // return ['chat.' .  $this->message->conversation_id];
    }

    public function broadcastAs()
    {
        return 'message_sent'; // listen for this name in JS
    }

    public function broadcastWith()
    {
        return [
            'message' => $this->message,
        ];
    }
}
