<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Repositories\SettingRepository;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    public function index()
    {
        $businessSettings = SettingRepository::getAllBusinessSettings();
        $addressSetting        = $businessSettings->where('type', 'Address')->first();
        $supportMailSetting    = $businessSettings->where('type', 'Support Mail')->first();
        $supportContactSetting = $businessSettings->where('type', 'Support Contact')->first();

        return view('web.about.about', compact(
            'addressSetting',
            'supportMailSetting',
            'supportContactSetting',

        ));
    }
}
