<?php

namespace App\Http\Controllers\Frontend;

use App\Events\ContactSubmitted;
use App\Events\NotifyManagementEvent;
use App\Http\Controllers\Controller;
use App\Http\Requests\ContactRequest;
use App\Repositories\ContactRepository;
use App\Repositories\SettingRepository;
use Illuminate\Http\Request;


class ContactUsController extends Controller
{
    public function index()
    {
        $businessSettings = SettingRepository::getAllBusinessSettings();
        $addressSetting        = $businessSettings->where('type', 'Address')->first();
        $supportMailSetting    = $businessSettings->where('type', 'Support Mail')->first();
        $supportContactSetting = $businessSettings->where('type', 'Support Contact')->first();

        return view('web.contact.contact-us', compact(
            'addressSetting',
            'supportMailSetting',
            'supportContactSetting',

        ));
    }

    public function store(ContactRequest $request)
    {
        $contact = ContactRepository::storeContact($request);
        if ($contact) {

            $receiverIds = null;
            $senderId = null;
            $subject = "New Contact Message Received";
            $body = "You have received a new contact message from {$request->name}. Please check the admin panel for more details.";
            // Notification
            NotifyManagementEvent::dispatch(
                $receiverIds,
                $senderId,
                $subject,
                $body
            );

            // Conforamtion Mail 
            // ContactSubmitted::dispatch($contact);
            return back()->withSuccess('Your From is Successfully Submited');
        }
        return back()->withError('Something went wrong!');
    }
}
