<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\SellingPost;
use App\Models\Wishlist;
use App\Repositories\SellingPostRepository;
use App\Repositories\WishlistRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WishlistController extends Controller
{

    public function index()
    {

        $wishlistIds = WishlistRepository::query()->where('user_id', Auth::id())
            ->pluck('selling_post_id')
            ->toArray();

        $products = SellingPostRepository::query()
            ->whereIn('id', $wishlistIds)
            ->with(['user', 'brand', 'thumbnails'])
            ->paginate(8);

        return view('web.profile.sections.wishlist', compact(
            'products',
            'wishlistIds',
        ));
    }

    public function addWishlist($postId)
    {
        $message = WishlistRepository::toggleWishlist($postId);

        return redirect()->back()->with('success', $message);
    }
}
