<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ColorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'code' => ['required', 'regex:/^#[0-9A-Fa-f]{6}$/'], // Only #RRGGBB
        ];
    }
    public function messages(): array
    {
        return [
            'code.regex' => 'Invalid color code! Please use the format #RRGGBB, e.g., #FF0000.',
        ];
    }
}
