<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SellerReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'seller_id' => ['integer'],
            'reporter_id' => ['integer'],
            'report_type' => ['required', 'string'],
            'details' => ['nullable', 'string', 'max:1000'],
        ];
    }
}
