<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRegistrationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $provider = $this->provider;
        $rules = [
            'name'      => 'required|string|max:255|regex:/^[A-Za-z][A-Za-z0-9\s._-]*$/'
        ];

        if (!$provider) {
            $rules['email'] = 'required|email|unique:users,email';
            $rules['phone_no'] = 'required|string|regex:/^[0-9+\-\s\(\)]+$/|unique:users,phone_no';
            $rules['password'] = 'required|string|min:6';
        } else {
            $rules['provider'] = 'required';
            $rules['provider_id'] = 'required';
        }
        return $rules;
    }
}
