<?php

namespace App\Repositories;

use Abedin\Maker\Repositories\Repository;
use App\Models\Message;
use App\Models\MessageThumbnail;

class MessageRepository extends Repository
{
    public static function model()
    {
        return Message::class;
    }


    public static function storeByRequest($request)
    {
        $senderId   = auth()->id();
        $receiverId = $request->receiver_id;

        // Get or create conversation
        $conversation = ConversationRepository::findBySenderAndReceiver($senderId, $receiverId);

        // First handle normal message
        $content = $request->message ?? $request->offer_message;

        // If offer, override content
        if ($request->filled('offer_price')) {
            $content = 'I will pay for it: ' . $request->offer_price;

            if ($request->filled('offer_message')) {
                $content .= "<br>" . $request->offer_message;
            }
        }

        // Create the message
        $message = self::create([
            'conversation_id' => $conversation->id,
            'sender_id'       => auth()->id(),
            'selling_post_id' => $request->selling_post_id ?? null,
            'receiver_id'     => $receiverId,
            'contact'         => $content,
        ]);



        // Optional file
        if ($request->hasFile('chatFile')) {
            $media = MediaRepository::storeByRequest($request->file('chatFile'), 'chat');

            MessageThumbnail::create([
                'message_id' => $message->id,
                'media_id'   => $media->id,
            ]);
        }

        return $message;
    }

    



}
