<?php

namespace Database\Factories;

use App\Models\SellingPost;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PostView>
 */
class PostViewFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $userIds = User::pluck('id')->toArray();
        $sellingPostIds = SellingPost::pluck('id')->toArray();
        return [
            'selling_post_id' => $this->faker->randomElement($sellingPostIds),
            'ip_address' => $this->faker->ipv4(),
            'user_id' => $this->faker->optional()->randomElement($userIds),
        ];
    }
}
