
    //---- Template Settings Active ----//
    $(document).ready(function () {
        const settingsPanel = $('.rs-template-settings');
        const settingsIcon = $('.rs-template-settings-icon');
        settingsIcon.on('click', function (e) {
            e.stopPropagation();
            settingsPanel.toggleClass('active');

            let icon = $(this).find('i');
            if (settingsPanel.hasClass('active')) {
                icon.removeClass('fa-cog').addClass('fa-times');
            } else {
                icon.removeClass('fa-times').addClass('fa-cog');
            }
        });
        $(document).on('click', function (e) {
            if (
                settingsPanel.hasClass('active') &&
                !$(e.target).closest('.rs-template-settings, .rs-template-settings-icon').length
            ) {
                settingsPanel.removeClass('active');
                settingsIcon.find('i').removeClass('fa-times').addClass('fa-cog');
            }
        });
    });


    // ===== Page rtl ===== //
    $(document).ready(function () {
        let dir = localStorage.getItem('page-direction') || 'ltr';
        $('html').attr('dir', dir);
        if (dir === 'rtl') {
            $('body').addClass('rtl-mode');
            $('.rs-template-settings-button-rtl button:contains("Rtl")').addClass('active');
            $('.rs-template-settings-button-rtl button:contains("Ltr")').removeClass('active');
        } else {
            $('body').removeClass('rtl-mode');
            $('.rs-template-settings-button-rtl button:contains("Ltr")').addClass('active');
            $('.rs-template-settings-button-rtl button:contains("Rtl")').removeClass('active');
        }

        // ===== Page Load: Restore Dark/Light =====
        let theme = localStorage.getItem('page-theme') || 'light';
        if (theme === 'dark') {
            $('body').addClass('dark-mode');
            $('.rs-template-settings-button button:contains("Dark")').addClass('active');
            $('.rs-template-settings-button button:contains("Light")').removeClass('active');
        } else {
            $('body').removeClass('dark-mode');
            $('.rs-template-settings-button button:contains("Light")').addClass('active');
            $('.rs-template-settings-button button:contains("Dark")').removeClass('active');
        }

        // ===== RTL/LTR Button Click (No Reload) =====
        $('.rs-template-settings-button-rtl button').on('click', function () {
            $(this).siblings().removeClass('active');
            $(this).addClass('active');

            dir = $(this).text().trim().toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
            localStorage.setItem('page-direction', dir);

            $('html').attr('dir', dir);
            if (dir === 'rtl') {
                $('body').addClass('rtl-mode');
            } else {
                $('body').removeClass('rtl-mode');
            }
        });

        // ===== Dark/Light Button Click (No Reload) =====
        $('.rs-template-settings-button button').on('click', function () {
            $(this).siblings().removeClass('active');
            $(this).addClass('active');

            theme = $(this).text().trim().toLowerCase() === 'dark' ? 'dark' : 'light';
            localStorage.setItem('page-theme', theme);

            if (theme === 'dark') {
                $('body').addClass('dark-mode');
            } else {
                $('body').removeClass('dark-mode');
            }
        });

    });



    // lang active btn
    document.addEventListener("DOMContentLoaded", function () {
        const langBtnWrapper = document.querySelector(".rs-language-btn");
        const langBtn = langBtnWrapper.querySelector("button");
        const settingsBox = document.querySelector(".rs-template-settings");
        const langItems = document.querySelectorAll(".rs-lang li");
        langBtn.addEventListener("click", function (e) {
            e.stopPropagation();
            langBtnWrapper.classList.toggle("active");
            settingsBox.classList.toggle("lang-open");
        });
        langItems.forEach(li => {
            li.addEventListener("click", function (e) {
                e.preventDefault();
                const flag = li.querySelector("img").src;
                const text = li.textContent.trim();
                langBtn.innerHTML = `<img src="${flag}" alt=""> ${text} <i class="down-angel far fa-angle-down"></i>`;

                langBtnWrapper.classList.remove("active");
                settingsBox.classList.remove("lang-open");
            });
        });
        document.addEventListener("click", function () {
            langBtnWrapper.classList.remove("active");
            settingsBox.classList.remove("lang-open");
        });
    });
