@extends('layouts.app')

@section('content')
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Section -->
            <x-table-header :title="'Theme Customization'" :subtitle="'Customize your website colors and appearance'" :icon="'fas fa-palette'" />

            <!-- Main Form Card -->
            <div class="card border-0 shadow-lg rounded-4">
                <div class="card-body p-0">
                    <form action="{{ route('theme.update') }}" method="POST" id="themeForm">
                        @csrf

                        <div class="row g-0">
                            <!-- Left Side - Color Inputs -->
                            <div class="col-lg-7 p-4 p-lg-5">
                                <h5 class="fw-bold mb-4 text-dark">{{ __('Color Palette') }}</h5>

                                <!-- Primary Color -->
                                <div class="mb-4 p-3 bg-light rounded-3">
                                    <label class="form-label fw-semibold d-flex align-items-center mb-3">
                                        <span class="color-dot me-2 rounded-circle"
                                            style="width: 12px; height: 12px; background: {{ old('primary_color', $themeData['primary_color'] ?? '#0d6efd') }};"></span>
                                        {{ __('Primary Color') }}
                                    </label>
                                    <div class="row g-3">
                                        <div class="col-auto">
                                            <input type="color" name="primary_color" id="primary_color"
                                                class="form-control form-control-color border-2"
                                                style="width: 80px; height: 50px; cursor: pointer;"
                                                value="{{ old('primary_color', $themeData['primary_color'] ?? '#0d6efd') }}"
                                                onchange="updateColorDisplay(this, 'primary')">
                                        </div>
                                        <div class="col">
                                            <input type="text" id="primary_color_text"
                                                class="form-control border-2 text-uppercase fw-bold"
                                                style="font-family: 'Courier New', monospace; height: 50px;"
                                                value="{{ old('primary_color', $themeData['primary_color'] ?? '#0d6efd') }}"
                                                pattern="^#[0-9A-Fa-f]{6}$" placeholder="#0d6efd"
                                                onchange="updateColorPicker(this, 'primary')">
                                        </div>
                                    </div>
                                    <small
                                        class="text-muted d-block mt-2">{{ __('Used for buttons, links, and primary elements') }}</small>
                                </div>


                                <!-- Text Color -->
                                <div class="mb-4 p-3 bg-light rounded-3">
                                    <label class="form-label fw-semibold d-flex align-items-center mb-3">
                                        <span class="color-dot me-2 rounded-circle"
                                            style="width: 12px; height: 12px; background: {{ old('text_color', $themeData['text_color'] ?? '#000000') }};"></span>
                                        {{ __('Text Color') }}
                                    </label>
                                    <div class="row g-3">
                                        <div class="col-auto">
                                            <input type="color" name="text_color" id="text_color"
                                                class="form-control form-control-color border-2"
                                                style="width: 80px; height: 50px; cursor: pointer;"
                                                value="{{ old('text_color', $themeData['text_color'] ?? '#000000') }}"
                                                onchange="updateColorDisplay(this, 'text')">
                                        </div>
                                        <div class="col">
                                            <input type="text" id="text_color_text"
                                                class="form-control border-2 text-uppercase fw-bold"
                                                style="font-family: 'Courier New', monospace; height: 50px;"
                                                value="{{ old('text_color', $themeData['text_color'] ?? '#000000') }}"
                                                pattern="^#[0-9A-Fa-f]{6}$" placeholder="#000000"
                                                onchange="updateColorPicker(this, 'text')">
                                        </div>
                                    </div>
                                    <small
                                        class="text-muted d-block mt-2">{{ __('Primary text color for content') }}</small>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-flex gap-3 mt-5">
                                    <x-update-button :title="'Save Changes'" :icon="'fas fa-save'"></x-update-button>

                                    <button type="button" onclick="resetToDefault()"
                                        class="btn btn-lg btn-outline-secondary px-4">
                                        <i class="fas fa-undo me-2"></i>{{ __('Reset') }}
                                    </button>
                                </div>
                            </div>

                            <!-- Right Side - Live Preview -->
                            <div class="col-lg-5 bg-light p-4 p-lg-5 border-start">
                                <h5 class="fw-bold mb-4 text-dark">{{ __('Live Preview') }}</h5>

                                <div class="p-4 bg-white rounded-3 shadow-sm border">
                                    <div class="mb-3">
                                        <div class="text-center py-3 rounded fw-semibold text-white" id="preview_primary"
                                            style="background: {{ old('primary_color', $themeData['primary_color'] ?? '#0d6efd') }};">
                                            {{ __('Primary Color Preview') }}
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="text-center py-3 rounded fw-semibold text-white" id="preview_secondary"
                                            style="background: {{ old('text_color', $themeData['text_color'] ?? '#000000') }};">
                                            {{ __('Text Color Preview') }}
                                        </div>
                                    </div>

                                    <div>
                                        <div class="p-4 bg-white rounded border">
                                            <h6 class="fw-bold mb-2" id="preview_text"
                                                style="color: {{ old('text_color', $themeData['text_color'] ?? '#000000') }};">
                                                {{ __('Heading Text') }}
                                            </h6>
                                            <p class="mb-0" id="preview_text2"
                                                style="color: {{ old('text_color', $themeData['text_color'] ?? '#000000') }};">
                                                {{ __('This is how your text will appear on the website.') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-info border-0 mt-4 rounded-3">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <small>{{ __('Changes will be applied across your entire website after saving.') }}</small>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <style>
        /* Bootstrap 5 Custom Enhancements */
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.25rem rgba(102, 126, 234, 0.25);
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 16px rgba(41, 25, 1, 0.4);
        }

        .bg-light:hover {
            background-color: #e9ecef !important;
            transition: all 0.3s ease;
        }

        .card {
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .card:hover {
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, .175) !important;
        }

        /* Smooth transitions */
        #preview_primary,
        #preview_secondary,
        #preview_background,
        #preview_text,
        #preview_text2 {
            transition: all 0.3s ease;
        }

        @media (max-width: 991px) {
            .border-start {
                border-start: none !important;
                border-top: 1px solid #dee2e6 !important;
                margin-top: 2rem;
            }
        }
    </style>

    <script>
        // Update color display in real-time
        function updateColorDisplay(input, type) {
            const color = input.value;
            document.getElementById(type + '_color_text').value = color;
            const dot = input.closest('.bg-light').querySelector('.color-dot');
            if (dot) dot.style.background = color;
            updatePreview(type, color);
        }

        // Update color picker from text input
        function updateColorPicker(input, type) {
            let color = input.value.trim();
            if (!/^#[0-9A-Fa-f]{6}$/.test(color)) {
                input.classList.add('is-invalid');
                return;
            }

            input.classList.remove('is-invalid');
            document.getElementById(type + '_color').value = color;
            const dot = input.closest('.bg-light').querySelector('.color-dot');
            if (dot) dot.style.background = color;
            updatePreview(type, color);
        }

        // Update live preview
        function updatePreview(type, color) {
            switch (type) {
                case 'primary':
                    document.getElementById('preview_primary').style.background = color;
                    break;
                case 'secondary':
                    document.getElementById('preview_secondary').style.background = color;
                    break;
                case 'background':
                    document.getElementById('preview_background').style.background = color;
                    break;
                case 'text':
                    document.getElementById('preview_text').style.color = color;
                    document.getElementById('preview_text2').style.color = color;
                    document.getElementById('preview_secondary').style.background = color;
                    break;
            }
        }

        // Reset to default colors
        function resetToDefault() {
            Swal.fire({
                title: 'Reset Colors?',
                text: "Are you sure you want to reset to default colors?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Reset',
                cancelButtonText: 'Cancel',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {

                    const defaults = {
                        primary: '#dd5454',
                        text: '#17181d'
                    };

                    Object.keys(defaults).forEach(type => {
                        document.getElementById(type + '_color').value = defaults[type];
                        document.getElementById(type + '_color_text').value = defaults[type];
                        updatePreview(type, defaults[type]);

                        const dot = document.getElementById(type + '_color').closest('.bg-light')
                            .querySelector('.color-dot');
                        if (dot) dot.style.background = defaults[type];
                    });

                    Swal.fire({
                        title: 'Reset Successful!',
                        text: 'Colors have been restored to default.',
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    });
                }
            });
        }
    </script>
@endsection
