<div class="d-flex justify-content-between align-items-center mb-3 p-3 rounded shadow-sm"
    style="background: linear-gradient(135deg, #46262a 0%, #16181c 100%);">

    {{-- Title --}}
    <div class="d-flex flex-column">
        <h3 class="fw-bold text-white mb-1 d-flex align-items-center">
            @if ($icon)
                <i class="{{ $icon }} me-2" style="font-size: 20px;"></i>
            @endif
            {{ $title }}
        </h3>

        <p class="text-white-50 small mb-0">
            {{ __($subtitle) }}
        </p>
    </div>


    <div class="d-flex justify-content-between align-items-center gap-4">
        {{-- Optional Button --}}
        @if ($buttonText && $buttonRoute)
            @can($buttonPermission)
                <a href="{{ $buttonRoute }}" class="btn btn-light border text-success fw-semibold d-flex align-items-center"
                    style="gap:4px;">
                    <i class="{{ $buttonIcon ?? 'bi bi-plus-lg' }}"></i> {{ $buttonText }}
                </a>
            @endcan
        @endif

        {{-- Search Bar --}}
        @if ($showSearch)
            <div class="d-flex justify-content-end">
                <form action="{{ $searchAction }}" method="GET">
                    <div class="input-group shadow-sm" style="width:300px;">
                        <input type="text" name="{{ $searchName }}" value="{{ $searchValue }}"
                            class="form-control px-3 py-0" placeholder="{{ __('Search...') }}"
                            style="background: #f8f9fa; border: 1px solid #dee2e6; height: 40px;">

                        <button type="submit" class="btn px-4 header-search-admin"
                            style="background: linear-gradient(135deg, #46262a 0%, #16181c 100%);
                               color: white;
                               border: 1px solid #46262a; z-index:0;">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        @endif
    </div>
</div>
