@extends('layouts.app')
@section('content')
    <!-- All-counter-start -->
    <section class="tp-ride-counter-area mt-16 mb-16">
        <div class="container-fluids">
            <div class="row">
                <div class="col-xl-12 col-12">
                    <div class="tp-ride-counter-wrapper tp-navy-blue-bg d-flex align-items-center justify-content-between">
                        <div class="tp-ride-counter-item">
                            <h4 class="tp-ride-counter">
                                <span>
                                    <i class="purecounter" data-purecounter-duration="3"
                                        data-purecounter-end="{{ countUser('Approve')['countNo'] }}">{{ countUser('Approve')['countNo'] }}</i>
                                </span>
                            </h4>
                            <div class="tp-ride-counter-text d-flex align-items-center justify-content-between">
                                <span>{{ __('Active Users') }}</span>
                                <div class="tp-ride-counter-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                            </div>
                        </div>

                        <div class="tp-ride-counter-item">
                            <h4 class="tp-ride-counter">
                                <span>
                                    <i class="purecounter" data-purecounter-duration="3"
                                        data-purecounter-end="{{ countPost('Approve')['countNo'] }}">
                                        {{ countPost('Approve')['countNo'] }}
                                    </i>
                                </span>
                            </h4>
                            <div class="tp-ride-counter-text d-flex align-items-center justify-content-between">
                                <span>{{ __('Active Posts') }}</span>
                                <div class="tp-ride-counter-icon">
                                    <i class="fas fa-pen"></i>

                                </div>
                            </div>
                        </div>


                        <div class="tp-ride-counter-item">
                            <h4 class="tp-ride-counter">
                                <span>
                                    <i class="purecounter" data-purecounter-duration="3"
                                        data-purecounter-end="{{ $boostPosts }}">{{ $boostPosts }}</i>
                                </span>
                            </h4>
                            <div class="tp-ride-counter-text d-flex align-items-center justify-content-between">
                                <span>{{ __('Total Boost Posts') }}</span>
                                <div class="tp-ride-counter-icon">
                                    <i class="fas fa-rocket"></i>
                                </div>
                            </div>
                        </div>


                        <div class="tp-ride-counter-item">
                            <h4 class="tp-ride-counter">
                                <span>
                                    <i class="purecounter" data-purecounter-duration="3"
                                        data-purecounter-end="{{ $contacts }}">{{ $contacts }}</i>
                                </span>
                            </h4>
                            <div class="tp-ride-counter-text d-flex align-items-center justify-content-between">
                                <span>{{ __('User Complaints') }}</span>
                                <div class="tp-ride-counter-icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- counter-end -->

    <!--analytics-start -->
    <section class="tp-analytics-area mb-16 fix">
        <div class="container-fluids">

            <div class="row">

                <div class="col-xl-4 col-lg-6 col-md-12">
                    <div class="tp-analytics-wrapper">
                        <h3 class="tp-analytics-title mb-16">
                            {{ __('Marketplace Analytics') }}
                        </h3>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-total.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Total Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span>{{ countPost()['countNo'] }}</span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-pending.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Pending Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('Pending')['color'] }}">
                                    {{ countPost('Pending')['countNo'] }}
                                </span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-in-review.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('In-Review Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('In-Review')['color'] }}">
                                    {{ countPost('In-Review')['countNo'] }}
                                </span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-approved.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Approved Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('Approve')['color'] }}">
                                    {{ countPost('Approve')['countNo'] }}
                                </span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-sold.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Sold Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('Soled')['color'] }}">
                                    {{ countPost('Soled')['countNo'] }}
                                </span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-rejected.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Rejected Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('Reject')['color'] }}">
                                    {{ countPost('Reject')['countNo'] }}
                                </span>
                            </div>
                        </div>
                        <div class="tp-analytics-item d-flex align-items-center justify-content-between mb-0">
                            <div class="tp-analytics-left d-flex align-items-center">
                                <img src="{{ asset('assets/img/analise/post-cancelled.png') }}" alt="">
                                <h4 class="tp-analytics-title-2">
                                    {{ __('Cancelled Posts') }}
                                </h4>
                            </div>
                            <div class="tp-analytics-number text-end">
                                <span data-border-color="{{ countPost('Cancel')['color'] }}">
                                    {{ countPost('Cancel')['countNo'] }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-xl-4 col-lg-6 col-md-12">
                    <div class="tp-analytics-wrapper tp-analytics-wrapper-end mb-8">
                        <h3 class="tp-analytics-title mb-16">
                            {{ __('Admin Wallet') }}
                        </h3>
                        <div class="tp-analytics-wrapper-2 mb-10">
                            <div class="tp-admin-wallet">
                                <h3 class="tp-admin-wallet-price">
                                    {{ number_format($totalEarnings, 2) }}

                                </h3>
                                <div
                                    class="tp-ride-earning-bottom-content d-flex align-items-center justify-content-between">
                                    <div class="tp-ride-earning">
                                        <span>{{ number_format($growthRate, 2) }}%
                                            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="11"
                                                viewBox="0 0 15 11" fill="none">
                                                <path
                                                    d="M5.56072 6.50979C4.76773 7.30391 4.00923 8.06466 3.24999 8.82578C2.6001 9.47567 1.95021 10.1246 1.30032 10.7725C1.08773 10.9835 0.831269 11.0488 0.542193 10.9637C0.253116 10.8786 0.0810205 10.6735 0.0172812 10.3836C-0.0442085 10.1017 0.0633984 9.87035 0.260615 9.67126C1.16196 8.77041 2.06256 7.86932 2.96241 6.96797C3.62955 6.30108 4.29719 5.63457 4.96532 4.96843C5.33164 4.60474 5.75569 4.60287 6.1205 4.9628C6.62742 5.46272 7.13096 5.96639 7.63112 6.4738C7.68774 6.53079 7.72336 6.6084 7.76348 6.66839L11.9763 2.45185C11.9163 2.4481 11.8585 2.44173 11.8004 2.44135C11.313 2.44135 10.8256 2.44623 10.3382 2.43835C10.0161 2.43348 9.77351 2.27713 9.64116 1.98431C9.51481 1.7046 9.5568 1.43315 9.75364 1.19469C9.82425 1.10631 9.91422 1.03533 10.0166 0.987224C10.119 0.939119 10.2311 0.915174 10.3442 0.917236C11.511 0.914611 12.6808 0.912362 13.8491 0.918361C14.2904 0.92061 14.6169 1.2558 14.6184 1.69635C14.6222 2.85866 14.6222 4.02096 14.6184 5.18327C14.6184 5.62494 14.2724 5.97064 13.8532 5.96689C13.434 5.96314 13.1108 5.63319 13.1033 5.19039C13.0962 4.71572 13.1015 4.24068 13.1015 3.76563V3.56879L13.0332 3.52455C12.9908 3.59136 12.9434 3.6549 12.8915 3.71464C11.3997 5.20914 9.90687 6.70251 8.41287 8.19476C8.02406 8.58282 7.60375 8.58357 7.21644 8.19814C6.70778 7.69172 6.19999 7.18368 5.69308 6.67402C5.64958 6.63015 5.61471 6.57616 5.56072 6.50979Z"
                                                    fill="#4BB543" />
                                            </svg>
                                        </span>
                                        <span class="tp-ride-earning-text">{{ __('Total Earning') }}</span>
                                    </div>
                                    <div class="tp-admin-wallet-icon">
                                        <img src="{{ asset('assets/img/icon/wallet-icon.png') }}" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="tp-withdraw-box box-1 mt-16">
                                    <h3 class="tp-withdraw-amount d-flex align-items-center justify-content-between">
                                        {{ number_format($totalWalletRecharge, 2) }}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none">
                                            <path opacity="0.4"
                                                d="M21 7V11.98C21 12.19 20.8 12.32 20.6 12.26C20.1 12.09 19.56 12 19 12C16.24 12 14 14.24 14 17C14 17.19 14.01 17.38 14.03 17.57C14.04 17.61 14.05 17.65 14.05 17.69C14.05 17.86 13.91 18 13.74 18H6C4 18 3 17 3 15V7C3 5 4 4 6 4H18C20 4 21 5 21 7Z"
                                                fill="#2BBA45" />
                                            <path
                                                d="M12 14C13.6569 14 15 12.6569 15 11C15 9.34315 13.6569 8 12 8C10.3431 8 9 9.34315 9 11C9 12.6569 10.3431 14 12 14Z"
                                                fill="#2BBA45" />
                                            <path
                                                d="M6 11.999C6.55228 11.999 7 11.5513 7 10.999C7 10.4467 6.55228 9.99902 6 9.99902C5.44772 9.99902 5 10.4467 5 10.999C5 11.5513 5.44772 11.999 6 11.999Z"
                                                fill="#2BBA45" />
                                            <path
                                                d="M21.5301 17.47C21.2371 17.177 20.762 17.177 20.469 17.47L19.749 18.19V15C19.749 14.586 19.413 14.25 18.999 14.25C18.585 14.25 18.249 14.586 18.249 15V18.189L17.529 17.469C17.236 17.176 16.761 17.176 16.468 17.469C16.175 17.762 16.175 18.237 16.468 18.53L18.468 20.53C18.614 20.676 18.806 20.75 18.998 20.75C19.19 20.75 19.382 20.677 19.528 20.53L21.528 18.53C21.823 18.238 21.8231 17.762 21.5301 17.47Z"
                                                fill="#2BBA45" />
                                        </svg>
                                    </h3>
                                    <div class="tp-withdraw-text">
                                        <p>
                                            {{ __('Total Wallet Recherge') }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="tp-withdraw-box box-2 mt-16">
                                    <h3 class="tp-withdraw-amount d-flex align-items-center justify-content-between">
                                        {{ number_format($totalDirectPurchaseEarnings, 2) }}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none">
                                            <path d="M20 7V9H2V7C2 5 3 4 5 4H17C19 4 20 5 20 7Z" fill="#FB5E61" />
                                            <path opacity="0.4"
                                                d="M20 9V11.45C20 11.62 19.86 11.75 19.69 11.75C19.65 11.75 19.61 11.74 19.57 11.73C19.07 11.58 18.55 11.5 18 11.5C14.97 11.5 12.5 13.97 12.5 17C12.5 17.23 12.51 17.46 12.54 17.69C12.54 17.86 12.4 18 12.23 18H5C3 18 2 17 2 15V9H20Z"
                                                fill="#FB5E61" />
                                            <path
                                                d="M9 14.75H6C5.586 14.75 5.25 14.414 5.25 14C5.25 13.586 5.586 13.25 6 13.25H9C9.414 13.25 9.75 13.586 9.75 14C9.75 14.414 9.414 14.75 9 14.75Z"
                                                fill="#FB5E61" />
                                            <path
                                                d="M18 13C15.79 13 14 14.79 14 17C14 19.21 15.79 21 18 21C20.21 21 22 19.21 22 17C22 14.79 20.21 13 18 13ZM19.35 17.65C19.55 17.84 19.55 18.16 19.35 18.35C19.26 18.45 19.13 18.5 19 18.5C18.87 18.5 18.74 18.45 18.65 18.35L18 17.7L17.35 18.35C17.26 18.45 17.13 18.5 17 18.5C16.87 18.5 16.74 18.45 16.65 18.35C16.45 18.16 16.45 17.84 16.65 17.65L17.3 17L16.65 16.35C16.45 16.16 16.45 15.84 16.65 15.65C16.84 15.45 17.16 15.45 17.35 15.65L18 16.3L18.65 15.65C18.84 15.45 19.16 15.45 19.35 15.65C19.55 15.84 19.55 16.16 19.35 16.35L18.7 17L19.35 17.65Z"
                                                fill="#FB5E61" />
                                        </svg>
                                    </h3>
                                    <div class="tp-withdraw-text">
                                        <p>
                                            {{ __('Direct Purchase Earnings') }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="tp-withdraw-box box-1 mt-16">
                                    <h3 class="tp-withdraw-amount d-flex align-items-center justify-content-between">
                                        {{ number_format($totalPendingPayments, 2) }}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none">
                                            <path opacity="0.4"
                                                d="M21 21H4.5C2.958 21 2 20.042 2 18.5V4C2 3.448 2.448 3 3 3C3.552 3 4 3.448 4 4V18.5C4 18.949 4.051 19 4.5 19H21C21.552 19 22 19.448 22 20C22 20.552 21.552 21 21 21Z"
                                                fill="#9747FF" />
                                            <path
                                                d="M13 17C12.448 17 12 16.552 12 16V12C12 11.448 12.448 11 13 11C13.552 11 14 11.448 14 12V16C14 16.552 13.552 17 13 17ZM19 16V10C19 9.448 18.552 9 18 9C17.448 9 17 9.448 17 10V16C17 16.552 17.448 17 18 17C18.552 17 19 16.552 19 16ZM9 16V14C9 13.448 8.552 13 8 13C7.448 13 7 13.448 7 14V16C7 16.552 7.448 17 8 17C8.552 17 9 16.552 9 16Z"
                                                fill="#9747FF" />
                                            <path
                                                d="M18.923 3.61804C18.822 3.37404 18.627 3.17903 18.382 3.07703C18.26 3.02603 18.13 3 18 3H15C14.448 3 14 3.448 14 4C14 4.552 14.448 5 15 5H15.586L13.668 6.91797C13.572 7.01297 13.405 7.01397 13.307 6.91797L12.157 5.76794C11.278 4.88794 9.84599 4.88794 8.96799 5.76794L7.29301 7.44299C6.90201 7.83399 6.90201 8.46606 7.29301 8.85706C7.48801 9.05206 7.74401 9.15002 8.00001 9.15002C8.25601 9.15002 8.51201 9.05206 8.70701 8.85706L10.382 7.18201C10.48 7.08401 10.646 7.08401 10.743 7.18201L11.893 8.33203C12.772 9.21103 14.203 9.21103 15.082 8.33203L17 6.41394V7C17 7.552 17.448 8 18 8C18.552 8 19 7.552 19 7V4C19 3.87 18.973 3.74004 18.923 3.61804Z"
                                                fill="#9747FF" />
                                        </svg>
                                    </h3>
                                    <div class="tp-withdraw-text">
                                        <p>
                                            {{ __('Total Pending Payment') }}
                                        </p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Top Sellers Section -->
                <div class="col-xl-4 col-lg-12 col-md-12">
                    <div class="tp-ride-driver-wrapper tp-navy-blue-bg br-8 mb-16">
                        <h3 class="tp-ride-driver-title mb-16">
                            {{ __('Top Sellers') }}
                        </h3>
                        @forelse ($topSellers as $sellerData)
                            <div class="tp-ride-driver-list-item d-flex align-items-center justify-content-between">
                                <div class="tp-ride-driver-list-item-left d-flex align-items-center">
                                    <div class="tp-ride-driver-author mr-8">
                                        <img src="{{ $sellerData['profile_photo'] }}"
                                            alt="{{ $sellerData['seller']?->name }}" class="img-fluid"
                                            style="width: 50px; height: 50px; border-radius:100%;">
                                    </div>
                                    <div class="tp-ride-driver-info">
                                        <a href="#" style="color: white">
                                            {{ $sellerData['seller']?->name }}
                                        </a>
                                        <div class="tp-ride-driver-author-rating">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <img src="{{ $i <= floor($sellerData['avg_rating']) ? asset('assets/img/icon/rating.svg') : asset('assets/img/icon/rating-2.svg') }}"
                                                    alt="">
                                            @endfor
                                            <span>
                                                {{ $sellerData['avg_rating'] }}
                                                <i>{{ '(' . $sellerData['review_count'] . ')' }}</i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tp-ride-driver-list-item-right">
                                    <div class="tp-ride-km">
                                        <span>
                                            {{ __('Posts') }} : {{ $sellerData['post_count'] }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="tp-ride-driver-list-item d-flex align-items-center justify-content-between">
                                <div class="tp-ride-driver-list-item-left tp-no-top-seller-found">
                                    <p>{{ __('No top sellers found') }}</p>
                                </div>
                            </div>
                        @endforelse
                    </div>
                </div>

            </div>

        </div>
    </section>
    <!--analytics-start -->

    <div class="tp-total-orders-area mb-8">
        <div class="container-fluids">
            <div class="row justify-content-center">
                <div class="col-xl-12 col-lg-12 col-md-12">
                    <div class="tp-total-orders-tab">
                        <h4 class="tp-total-orders-tab-title">
                            Statistics
                        </h4>
                        <div class="tp-total-orders-tab-button d-flex align-items-center justify-content-end ml-30 gap-7">
                            <a href="{{ route('dashboard', ['type' => 'daily']) }}"
                                class="tp-total-orders-tab-button {{ request()->type == 'daily' || is_null(request()->type) ? 'selected' : '' }}"
                                style="margin-right: 10px;">
                                Daily
                            </a>
                            <a href="{{ route('dashboard', ['type' => 'monthly']) }}"
                                class="tp-total-orders-tab-button {{ request()->type == 'monthly' ? 'selected' : '' }}"
                                style="margin-right: 10px;">
                                Monthly
                            </a>
                            <a href="{{ route('dashboard', ['type' => 'yearly']) }}"
                                class="tp-total-orders-tab-button {{ request()->type == 'yearly' ? 'selected' : '' }}">
                                Yearly
                            </a>
                        </div>


                    </div>
                    <div class="card total-orders-card p-4 fix">
                        <div id="total-orders-chart"></div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!--summary-start -->
    <section class="tp-summary-area mb-120 ">
        <div class="container-fluids">
            <div class="row">
                <div class="col-12">
                    <div class="ride-summary" data-bg-color="#fff">
                        <h3 class="tp-summary-title">{{ __('Boost Plan Sold Summary') }} <span>(
                                {{ __('Latest 5 Boostplan Sold') }} )</span>
                        </h3>
                        <div class="ride-table-wrapper">
                            <table class="ride-table">
                                <thead>
                                    <tr class="tp-summary-header-title-blue text-center">
                                        <th style="min-width:30px;">#</th>
                                        <th style="min-width:150px;">{{ __('Plan Name') }}</th>
                                        <th style="min-width:120px;">{{ __('Payable Amount') }}</th>
                                        <th style="min-width:100px;">{{ __('Discount') }}</th>
                                        <th style="min-width:100px;">{{ __('Sustain Days') }}</th>
                                        <th style="min-width:100px;">{{ __('Sold Count') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($boostplansold as $sold)
                                        <tr class="text-center">
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $sold->name }}</td>
                                            <td>{{ currencyFormat($sold->payable_amount) }}</td>
                                            <td>{{ currencyFormat($sold->discount_amount) }}</td>
                                            <td>{{ $sold->sustain_days }}</td>
                                            <td>{{ $sold->boost_posts_count }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">{{ __('No plans found.') }}
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('scripts')
    <script>
        const filterPosts = @json($filterPosts);
        const totalOrders = filterPosts.values.reduce((sum, val) => sum + val, 0);
        console.log(totalOrders, 'ad');


        const lightColors = ['#FDF3F3', '#FBE5E5', '#F9CFCF', '#F3AEAE', '#DD5454'];
        const darkColors = ['#2D3E50', '#33475B', '#3C5A75', '#4D7AA3', '#d0bb5bff'];

        document.getElementById("darkModeToggle").addEventListener("click", function() {
            const isDark = document.body.classList.contains("dark-theme");

            chart.updateOptions({
                colors: !isDark ? darkColors : lightColors,
            });
        });
        const values = filterPosts.values;


        const maxSegments = 100;
        const segments = [];

        for (let segmentIndex = 0; segmentIndex < maxSegments; segmentIndex++) {
            const segmentData = values.map(val => {
                const remaining = val - segmentIndex * 2;
                if (remaining >= 2) return 2;
                else if (remaining > 0) return remaining;
                else return null;
            });
            if (segmentData.every(d => d === null)) break;
            segments.push({
                name: `Segment ${segmentIndex + 1}${segmentIndex === 0 ? ' (Bottom)' : ''}`,
                data: segmentData
            });
        }

        var options = {
            series: segments,
            chart: {
                type: 'bar',
                height: 398,
                stacked: true,
                toolbar: {
                    show: false
                }
            },
            colors: lightColors,
            plotOptions: {
                bar: {
                    columnWidth: '57px',
                    borderRadius: 8,
                    borderRadiusApplication: 'end',
                    borderRadiusWhenStacked: 'last',
                }
            },
            responsive: [{
                    breakpoint: 768,
                    options: {
                        plotOptions: {
                            bar: {
                                columnWidth: '50px'
                            }
                        }
                    }
                },
                {
                    breakpoint: 480,
                    options: {
                        plotOptions: {
                            bar: {
                                columnWidth: '30px',
                                borderRadius: 5
                            }
                        }
                    }
                }
            ],
            xaxis: {
                categories: filterPosts.labels,
                axisTicks: {
                    show: false
                },
                labels: {
                    style: {
                        fontSize: '14px',
                        colors: '#727273'
                    }
                }
            },
            yaxis: {
                min: 0,
                max: 10,
                tickAmount: 5,
                labels: {
                    style: {
                        fontSize: '14px',
                        colors: '#727273'
                    }
                },
                yaxis: {
                    min: 0,
                    max: 10,
                    tickAmount: 5,
                    labels: {
                        formatter: function(val) {
                            return val.toString();
                        },
                        style: {
                            fontSize: '14px',
                            colors: '#727273'
                        }
                    }
                }
            },

            dataLabels: {
                enabled: true,
                formatter: function() {
                    return '';
                },
                offsetY: -5,
                style: {
                    fontSize: '12px',
                    colors: ['#687387']
                }
            },

            grid: {
                show: true,
                borderColor: '#f0f0f0',
                strokeDashArray: 5,
                position: 'back',
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: true
                    }
                }
            },

            legend: {
                show: false
            },
            tooltip: {
                enabled: true,
                y: {
                    formatter: val => val.toFixed(0)
                }
            },

            title: {
                text: totalOrders,
                align: 'left',
                offsetY: 0,
                style: {
                    fontSize: '32px',
                    fontWeight: '700',
                    color: '#727273'

                }
            },
            subtitle: {
                text: 'Total Sold Product',
                align: 'left',
                offsetY: 45,
                style: {
                    fontSize: '16px',
                    fontWeight: '400',
                    color: '#727273'
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#total-orders-chart"), options);
        chart.render();
    </script>
@endpush
