<!DOCTYPE html>
<html lang="en" style="scroll-behavior: smooth;overscroll-behavior: none;">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $appname->value }}</title>
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/magnific-popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/fontawesome-pro.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/animate.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/animate.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/swiper-bundle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/style.css') }}">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>



<!-- Place favicon.ico in the root directory -->
<link rel="shortcut icon" type="image/x-icon"
    href="{{ $fav->fav_url ? $fav->fav_url : asset('assets/frontend/img/logo/favicon.png') }}">

<body class="rs-magic-cursor">

    <!-- Begin magic cursor -->
    <div id="magic-cursor" class="cursor-black-bg">
        <div id="ball"></div>
    </div>
    <!-- End magic cursor -->



    <section class="rs-log-in-area fix">
        <div class="rs-log-in-bg" data-bg-img="{{ asset('assets/frontend/img/bg/log-in-bg.jpg') }}">
            <div class="rs-log-in-box backdrop-filter-15" data-bg-color="rgba(255, 255, 255, 0.08)">
                <div class="rs-log-in-img ">
                    <img src="{{ asset('assets/frontend/img/log-in/log-in-01.jpg') }}" alt="">
                </div>

                <div class="rs-log-in-right">
                    @if (session('success'))
                        <script>
                            const Toast = Swal.mixin({
                                toast: true,
                                position: "top-end",
                                showConfirmButton: false,
                                timer: 3000,
                                timerProgressBar: true,
                                didOpen: (toast) => {
                                    toast.onmouseenter = Swal.stopTimer;
                                    toast.onmouseleave = Swal.resumeTimer;
                                }
                            });
                            Toast.fire({
                                icon: "success",
                                title: "{{ session('success') }}"
                            });
                        </script>
                    @endif

                    @if (session('error'))
                        <script>
                            const Toast = Swal.mixin({
                                toast: true,
                                position: "top-end",
                                showConfirmButton: false,
                                timer: 3000,
                                timerProgressBar: true,
                                didOpen: (toast) => {
                                    toast.onmouseenter = Swal.stopTimer;
                                    toast.onmouseleave = Swal.resumeTimer;
                                }
                            });
                            Toast.fire({
                                icon: "error",
                                title: "{{ session('error') }}"
                            });
                        </script>
                    @endif
                    <div class="rs-log-in-top text-center p-24 mb-14">
                        <a href="{{ route('home') }}" class="rs-log-in-logo p-relative mb-40 d-block">
                            <img src="{{ $applogo->logo_url ? $applogo->logo_url : asset('assets/frontend/img/logo/login-logo.png') }}"
                                alt="" style="max-height: 32px">
                            <div class="rs-log-in-shape p-absolute">
                                <img src="{{ asset('assets/frontend/img/log-in/login-line-shape.svg') }}"
                                    alt="">
                            </div>
                        </a>
                    </div>
                    <div
                        class="rs-sign-up-more d-flex align-items-center gap-8 justify-content-center d-none d-md-flex">
                      
                        <a href="{{ route('social.auth.redirect', 'google') }}" class="d-flex align-items-center">
                            <img src="{{ asset('assets/frontend/img/icon/Google-Icon.svg') }}" alt="">

                            {{__('Google')}}
                        </a>
                        <a href="{{ route('social.auth.redirect', 'facebook') }}" class="d-flex align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24"
                                fill="none">
                                <g clip-path="url(#clip0_306_111577)">
                                    <path
                                        d="M24.5 12C24.5 5.3726 19.1274 1.52588e-05 12.5 1.52588e-05C5.87259 1.52588e-05 0.5 5.3726 0.5 12C0.5 17.6278 4.37432 22.3499 9.60108 23.6466V15.667H7.12659V12H9.60108V10.4199C9.60108 6.33548 11.4495 4.44236 15.4594 4.44236C16.2196 4.44236 17.5314 4.5914 18.068 4.74049V8.06468C17.7848 8.03487 17.2929 8.01995 16.6817 8.01995C14.714 8.01995 13.9538 8.76529 13.9538 10.7031V12H17.8734L17.2001 15.667H13.9538V23.9121C19.8955 23.1945 24.5 18.1353 24.5 12Z"
                                        fill="#0866FF" />
                                    <path
                                        d="M17.2 15.667L17.8734 12H13.9538V10.7031C13.9538 8.76524 14.714 8.01995 16.6817 8.01995C17.2929 8.01995 17.7848 8.03483 18.068 8.06464V4.7405C17.5314 4.59141 16.2196 4.44232 15.4594 4.44232C11.4495 4.44232 9.60107 6.33549 9.60107 10.4199V12H7.12657V15.667H9.60107V23.6466C10.5295 23.8769 11.5003 24 12.5 24C12.9922 24 13.4772 23.9697 13.9538 23.9121V15.667H17.2Z"
                                        fill="white" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_306_111577">
                                        <rect width="24" height="24" fill="white" transform="translate(0.5)" />
                                    </clipPath>
                                </defs>
                            </svg>
                            {{__('Facebook')}}
                        </a>
                    </div>
                    <span class="rs-log-in-or-content mb-12">{{ __('Sign Up With') }}</span>
                    <div class="rs-log-in-form">
                        <form action="{{ route('user.login.submit') }}" method="POST">
                            @csrf
                            <div class="rs-input-item-2">
                                <div class="rs-input-item">
                                    <h4 class="rs-input-title">
                                        {{ __('Email Or Phone No') }}
                                    </h4>
                                    <input type="text" name="contact" class="@error('contact') @enderror"
                                        placeholder="{{ __('Enter Your Email') }}" value="{{ old('contact') }}">
                                    @error('contact')
                                        <small style="color:red">
                                            {{ $message }}
                                        </small>
                                    @enderror
                                </div>
                                <div class="rs-input-item">
                                    <h4 class="rs-input-title">
                                        {{ __('Password') }}
                                    </h4>
                                    <div class="p-relative">
                                        <input type="password" name="password" id="passwordInput"
                                            class="form-control @error('password') @enderror"
                                            placeholder="{{ __('********') }}" value="{{ old('password') }}">
                                        <i class="far fa-eye" id="togglePassword"
                                            style="position:absolute; top:50%; right:15px; transform:translateY(-35%); cursor:pointer;"></i>
                                    </div>
                                    @error('password')
                                        <small style="color:red">
                                            {{ $message }}
                                        </small>
                                    @enderror
                                </div>
                            </div>
                            <button type="submit" class="rs-log-in-btn">
                                {{ __('Sign in') }}
                            </button>
                        </form>
                        <div
                            class="rs-sign-up-more d-flex align-items-center gap-8 justify-content-center d-md-none mt-30 mb-30">
                            <a href="javascript:void(0)" class="d-flex align-items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="24"
                                    viewBox="0 0 21 24" fill="none">
                                    <path
                                        d="M19.9375 18.7033C19.5745 19.5418 19.1449 20.3136 18.6472 21.0232C17.9687 21.9906 17.4131 22.6602 16.985 23.0321C16.3213 23.6424 15.6102 23.955 14.8488 23.9728C14.3021 23.9728 13.6429 23.8172 12.8755 23.5017C12.1056 23.1876 11.3981 23.0321 10.7511 23.0321C10.0726 23.0321 9.34495 23.1876 8.5666 23.5017C7.78707 23.8172 7.15909 23.9817 6.67896 23.9979C5.94876 24.0291 5.22093 23.7076 4.49444 23.0321C4.03075 22.6276 3.45077 21.9343 2.75597 20.9521C2.01052 19.9033 1.39765 18.687 0.917514 17.3004C0.403308 15.8026 0.145538 14.3523 0.145538 12.9482C0.145538 11.3398 0.493083 9.95259 1.18921 8.79011C1.7363 7.85636 2.46413 7.11979 3.37506 6.57906C4.286 6.03834 5.27026 5.76279 6.33023 5.74516C6.91021 5.74516 7.67078 5.92457 8.61593 6.27715C9.55842 6.63091 10.1636 6.81032 10.4289 6.81032C10.6273 6.81032 11.2996 6.60054 12.4392 6.18234C13.517 5.7945 14.4266 5.63391 15.1717 5.69717C17.1909 5.86012 18.7079 6.6561 19.7168 8.09013C17.9109 9.18432 17.0176 10.7169 17.0354 12.6829C17.0517 14.2142 17.6072 15.4886 18.699 16.5004C19.1938 16.97 19.7464 17.333 20.3612 17.5907C20.2279 17.9774 20.0871 18.3477 19.9375 18.7033ZM15.3065 0.480137C15.3065 1.68041 14.868 2.8011 13.994 3.83841C12.9392 5.07155 11.6634 5.78413 10.2799 5.67168C10.2623 5.52769 10.252 5.37614 10.252 5.21688C10.252 4.06462 10.7536 2.83147 11.6444 1.82321C12.0892 1.3127 12.6548 0.888228 13.3407 0.549615C14.0251 0.216055 14.6725 0.031589 15.2814 0C15.2991 0.160458 15.3065 0.320926 15.3065 0.480121V0.480137Z"
                                        fill="white" />
                                </svg>
                            </a>
                            <a href="javascript:void(0)" class="d-flex align-items-center">
                                <img src="{{ asset('assets/frontend/img/icon/Google Icon.png') }}" alt="">
                            </a>
                            <a href="javascript:void(0)" class="d-flex align-items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24"
                                    viewBox="0 0 25 24" fill="none">
                                    <g clip-path="url(#clip0_306_111577)">
                                        <path
                                            d="M24.5 12C24.5 5.3726 19.1274 1.52588e-05 12.5 1.52588e-05C5.87259 1.52588e-05 0.5 5.3726 0.5 12C0.5 17.6278 4.37432 22.3499 9.60108 23.6466V15.667H7.12659V12H9.60108V10.4199C9.60108 6.33548 11.4495 4.44236 15.4594 4.44236C16.2196 4.44236 17.5314 4.5914 18.068 4.74049V8.06468C17.7848 8.03487 17.2929 8.01995 16.6817 8.01995C14.714 8.01995 13.9538 8.76529 13.9538 10.7031V12H17.8734L17.2001 15.667H13.9538V23.9121C19.8955 23.1945 24.5 18.1353 24.5 12Z"
                                            fill="#0866FF" />
                                        <path
                                            d="M17.2 15.667L17.8734 12H13.9538V10.7031C13.9538 8.76524 14.714 8.01995 16.6817 8.01995C17.2929 8.01995 17.7848 8.03483 18.068 8.06464V4.7405C17.5314 4.59141 16.2196 4.44232 15.4594 4.44232C11.4495 4.44232 9.60107 6.33549 9.60107 10.4199V12H7.12657V15.667H9.60107V23.6466C10.5295 23.8769 11.5003 24 12.5 24C12.9922 24 13.4772 23.9697 13.9538 23.9121V15.667H17.2Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_306_111577">
                                            <rect width="24" height="24" fill="white"
                                                transform="translate(0.5)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </a>
                        </div>
                        <span class="rs-log-in-already">{{ __('Already have an account') }}?<a
                                href="{{ route('user.register') }}">{{ __('Sign Up') }}</a></span>
                    </div>
                </div>
            </div>
        </div>
    </section>




    <script src="{{ asset('assets/frontend/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/jarallax.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/gsap.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/tp-cursor.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/wow.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/jquery.counterup.min.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/main.js') }}"></script>
</body>

<script>
    const togglePassword = document.querySelector('#togglePassword');
    const passwordInput = document.querySelector('#passwordInput');

    togglePassword.addEventListener('click', () => {
        // Toggle input type
        const type = passwordInput.type === 'password' ? 'text' : 'password';
        passwordInput.type = type;

        // Toggle icon
        if (type === 'password') {
            togglePassword.classList.remove('fa-eye');
            togglePassword.classList.add('fa-eye-slash');
        } else {
            togglePassword.classList.remove('fa-eye-slash');
            togglePassword.classList.add('fa-eye');
        }
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function() {

        // Login success → only for authenticated users
        @if (session('login_success'))
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: '{{ session('login_success') }}',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });
        @endif

        // Logout success → only for guest users
        @if (session('logout_success'))
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: '{{ session('logout_success') }}',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });
        @endif

    });
</script>




</html>
