<!-- Template rtl start -->
<div class="rs-template-settings">
    <div class="rs-template-settings-top">
        <div class="rs-template-settings-icon">
            <i class="far fa-cog"></i>
        </div>
        <h3 class="rs-template-settings-title">
            {{ __('Template Settings') }}
        </h3>
        <div class="rs-template-settings-button mb-10 d-flex align-items-center justify-content-between">
            <button class="active"><i class="far fa-moon"></i>{{ __('Dark ') }}</button>
            <button><i class="far fa-sun"></i>{{ __('Light ') }}</button>
        </div>
        <div
            class="rs-template-settings-button mb-10 rs-template-settings-button-rtl d-flex align-items-center justify-content-between">
            <button>{{ __('Rtl') }}</button>
            <button class="active">Ltr</button>
        </div>
        <h3 class="rs-lang-title">
            {{ __('select language') }}
        </h3>
        @php
            $languages = \App\Repositories\LanguageRepository::getAll()->where('status','1');
            $currentLang =
                            $languages->firstWhere('name', session('locale')) ?? $languages->firstWhere('name', 'en');

                        $currentImg =
                            $currentLang && $currentLang->thumbnail
                                ? asset('storage/' . $currentLang->thumbnail->src)
                                : asset('assets/frontend/img/flag/en.jpg');
            $currentTitle = $currentLang ? $currentLang->title : 'English';
        @endphp



        <div class="rs-language-btn d-flex align-items-center justify-content-center p-relative">
            <button type="button" class="d-flex align-items-center justify-content-center gap-8"
                onclick="event.stopPropagation();">
                <img src="{{ $currentImg }}" alt="{{ $currentTitle }}" width="20" height="20"
                    style="object-fit: cover; border-radius: 3px;">
                {{ $currentTitle }}
                <i class="down-angel far fa-angle-down"></i>
            </button>

            <ul class="rs-lang p-absolute">
                @foreach ($languages as $lang)
                    @php
                        $langImg = $lang->thumbnail
                            ? asset('storage/' . $lang->thumbnail->src)
                            : asset('assets/frontend/img/flag/default-flag.png');
                        $langTitle = $lang->title ?? 'Language';
                    @endphp
                    <li>
                        <a href="{{ route('change.language', ['language' => $lang->name]) }}">
                            <img src="{{ $langImg }}" alt="{{ $langTitle }}" width="20" height="20"
                                style="object-fit: cover; border-radius: 3px;">
                            {{ $langTitle }}
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>

    </div>
</div>

@push('style')
    <style>
        .rs-lang a {
            pointer-events: auto !important;
            z-index: 9999;
        }
    </style>
@endpush

@push('script')
    <script>
        document.querySelectorAll('.rs-lang a').forEach(el => {
            el.addEventListener('click', function(e) {
                e.stopPropagation(); // stop parent dropdown JS
                window.location.href = this.href; // force redirect
            });
        });
    </script>
@endpush
