@extends('web.layouts.master')
@section('content')
    <!-- product details start -->
    <section class="rs-details-area mt-55">
        <div class="container">
            <div class="rs-details-wrapper mb-24 p-24 br-8" data-bg-color="#F6F7F9">
                <div class="row">

                    <div class="col-xl-6 col-lg-12 col-md-12">
                        <div class="swiper rs-details-slide-2">
                            <div class="swiper-wrapper">
                                @foreach ($productImg->allImages as $image)
                                    <div class="swiper-slide">
                                        <img src="{{ $image }}" alt="Product Image">
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="swiper rs-details-slide">
                            <div class="swiper-wrapper">
                                @foreach ($productImg->allImages as $image)
                                    <div class="swiper-slide">
                                        <img src="{{ $image }}" alt="Product Image">
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>


                    <div class="col-xl-6 col-lg-12 col-md-12">
                        <div class="rs-product-details-info br-4 p-16 mb-24 fix" data-bg-color="#fff">
                            <h2 class="rs-product-details-info-title">
                                <a href="javascript:void(0)">
                                    {{ $products->name ?? 'Untitled Product' }}
                                </a>
                            </h2>
                            <a href="javascript:void(0)"
                                class="rs-product-details-info-posted d-flex align-items-center mb-12 gap-61">{{ __('Posted
                                                                                                                                                                                                on:') }}<span>{{ $products->created_at ? $products->created_at->diffForHumans() : 'Just now' }}</span></a>
                            <a href="javascript:void(0)"
                                class="rs-product-details-info-condition d-flex align-items-center mb-12 gap-62">{{ __('Condition:') }}<span>{{ $products->conditions ?? 'N/A' }}</span></a>
                            <a href="javascript:void(0)"
                                class="rs-product-details-info-location d-flex align-items-center gap-72">{{ __('Location:') }}<span>{{ $location_name ?? 'Unknown Location' }}</span></a>
                            <div class="rs-details-bottom-area">
                                <div
                                    class="rs-product-details-price mt-24 mb-24 d-flex align-items-center justify-content-between">
                                    <a href="javascript:void(0)">
                                        {{ currencyFormat($products->asking_price) ?? '0.00' }}
                                        <span>
                                            {{ $products->is_negotiable == 1 ? __('Negotiable') : __('Fixed Price') }}
                                        </span>
                                       
                                    </a>
                                </div>
                                <div
                                    class="rs-product-details-info-btn d-flex align-items-center justify-content-between gap-16">

                                    {{-- Edit Ads Button --}}
                                    <a href="{{ route('product.edit', $products->id) }}"
                                        class="rs-product-details-massage-btn rs-btn d-flex align-items-center justify-content-center gap-10">
                                        <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.02 12.47L18.03 11.48C17.72 11.17 17.3091 11 16.8721 11C16.8711 11 16.8701 11 16.8701 11C16.4321 11 16.0189 11.172 15.7109 11.483L10.22 16.999C10.079 17.139 10.001 17.33 10.001 17.528V19.75C10.001 20.164 10.337 20.5 10.751 20.5H12.9741C13.1721 20.5 13.3629 20.421 13.5029 20.281L19.019 14.79C19.33 14.481 19.5 14.069 19.501 13.631C19.5 13.193 19.33 12.781 19.02 12.47ZM16.8711 12.5C16.8971 12.5 16.935 12.507 16.969 12.541L17.959 13.531C17.993 13.565 18 13.604 18 13.63C18 13.656 17.993 13.694 17.959 13.728L17.323 14.361L16.1389 13.177L16.772 12.541C16.807 12.507 16.8451 12.5 16.8711 12.5ZM12.6631 19H11.5V17.837L15.0811 14.24L16.26 15.419L12.6631 19ZM7.75 18H3.75C2.173 18 1.5 17.327 1.5 15.75V3.75C1.5 2.173 2.173 1.5 3.75 1.5H9V3.75C9 6.168 10.332 7.5 12.75 7.5H15V8.75C15 9.164 15.336 9.5 15.75 9.5C16.164 9.5 16.5 9.164 16.5 8.75V6.75C16.5 6.551 16.421 6.36 16.28 6.22L10.28 0.220001C10.139 0.0790012 9.949 0 9.75 0H3.75C1.332 0 0 1.332 0 3.75V15.75C0 18.168 1.332 19.5 3.75 19.5H7.75C8.164 19.5 8.5 19.164 8.5 18.75C8.5 18.336 8.164 18 7.75 18ZM10.5 3.75V2.561L13.939 6H12.75C11.173 6 10.5 5.327 10.5 3.75ZM4.75 9C4.336 9 4 9.336 4 9.75C4 10.164 4.336 10.5 4.75 10.5H11.75C12.164 10.5 12.5 10.164 12.5 9.75C12.5 9.336 12.164 9 11.75 9H4.75ZM8.75 13H4.75C4.336 13 4 13.336 4 13.75C4 14.164 4.336 14.5 4.75 14.5H8.75C9.164 14.5 9.5 14.164 9.5 13.75C9.5 13.336 9.164 13 8.75 13Z"
                                                fill="currentColor" />
                                        </svg>
                                        {{ __('Edit Ads') }}
                                    </a>



                                    @php
                                        $isApproved = $products->status === 'Approve';
                                    @endphp

                                    <a href="{{ $isApproved ? route('product.promote', $products->id) : 'javascript:void(0)' }}"
                                        style="flex: 0 0 48.6%;"
                                        class="w-100 rs-promotadd-mobilebtn {{ !$isApproved ? 'disabled opacity-50 pointer-events-none' : '' }}"
                                        title="{{ !$isApproved ? 'It will be clickable only if the status is Approved.' : '' }}">
                                        @csrf
                                        <button type="button"
                                            class="rs-btn rs-product-offer-btn d-flex align-items-center justify-content-center gap-10 w-100">
                                            @if ($products->activeBoost)
                                                {{ __('Promoted (Expires: ' . \Carbon\Carbon::parse($products->activeBoost->expired_at)->format('d M') . ')') }}
                                            @else
                                                {{ __('Promote Ads') }}
                                            @endif
                                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20"
                                                viewBox="0 0 21 20" fill="none">
                                                <path
                                                    d="M19.2991 0.417495C18.7131 0.136495 18.0331 0.212522 17.5281 0.619522L16.496 1.4435C15.039 2.6095 13.209 3.25148 11.344 3.25148H5.99902C3.10402 3.25148 0.75 5.6065 0.75 8.5005C0.75 11.2285 2.84799 13.4505 5.51099 13.7005L7.776 18.2305C8.245 19.1685 9.18808 19.7505 10.2361 19.7505H11.499C11.72 19.7505 11.929 19.6535 12.071 19.4855C12.213 19.3175 12.275 19.0945 12.239 18.8775L11.385 13.7515C13.236 13.7615 15.049 14.4005 16.495 15.5575L17.525 16.3815C17.831 16.6255 18.198 16.7505 18.569 16.7505C18.816 16.7505 19.065 16.6955 19.298 16.5825C19.884 16.3015 20.248 15.7225 20.248 15.0725V1.9275C20.249 1.2785 19.8851 0.699495 19.2991 0.417495ZM2.24902 8.5005C2.24902 6.4335 3.93105 4.75148 5.99805 4.75148H11.343C12.158 4.75148 12.966 4.64649 13.749 4.44649V12.5545C12.966 12.3545 12.157 12.2495 11.343 12.2495H5.99805C3.93105 12.2495 2.24902 10.5675 2.24902 8.5005ZM10.235 18.2505C9.75799 18.2505 9.33007 17.9855 9.11707 17.5595L7.21204 13.7495H9.86304L10.613 18.2505H10.235ZM18.749 15.0725C18.749 15.1455 18.716 15.1995 18.649 15.2315C18.583 15.2625 18.518 15.2565 18.462 15.2105L17.432 14.3865C16.763 13.8515 16.027 13.4125 15.248 13.0725V3.92848C16.026 3.58848 16.762 3.14949 17.431 2.61549L18.463 1.79048C18.519 1.74548 18.581 1.73748 18.649 1.76948C18.694 1.79148 18.749 1.83648 18.749 1.92848V15.0725Z"
                                                    fill="currentColor"></path>
                                            </svg>
                                        </button>
                                    </a>




                                </div>

                            </div>
                        </div>
                        <div class="rs-product-details-info-bottom br-4 p-16" data-bg-color="#fff">

                            <div class="rs-totle__views d-flex align-items-center justify-content-between gap-16">
                                <a href="javascript:void(0)">
                                    <img src="{{ asset('assets/frontend/img/icon/eye.svg') }}" alt="">
                                    Total Views:
                                    <span>{{ $products->increment('number_of_view') ?? 0 }}</span>
                                </a>
                                <a href="javascript:void(0)">
                                    <img src="{{ asset('assets/frontend/img/icon/heart-2.svg') }}" alt="">
                                    {{ __('Favorites:') }}<span>{{ $wishlistCount }}</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- product details start -->

    <!-- product info start -->
    <section class="rs-product-info-area mb-48">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-md-12 col-12">
                    <div class="rs-product-info-contant">
                        <div class="rs-product-info-head mb-16">
                            <h3 class="rs-product-info-title">
                                {{ __('Product Information') }}
                            </h3>
                        </div>
                        <div class="rs-product-about pl-16 mb-24">
                            <h4 class="rs-product-about-title">
                                {{ __('About Product') }}
                            </h4>
                            <div class="rs-product-brand d-flex align-items-center gap-16">
                                <p>{{ __('Brand') }}</p>
                                <span>{{ optional($products->brand)->name ?? 'N/A' }}</span>
                            </div>
                            <div class="rs-product-model d-flex align-items-center gap-16">
                                <p>{{ __('Model') }}</p>
                                <span>{{ $products->model ?? 'N/A' }}</span>
                            </div>
                            <div class="rs-product-warranty d-flex align-items-center gap-16">
                                <p>{{ __('Warranty') }}</p>
                                <span>{{ $products->warranty_left }} {{ __('days') }}</span>

                            </div>


                            <div class="rs-product-color d-flex align-items-center gap-16">
                                <p>{{ __('Color') }}</p>
                                <span>{{ $color->name ?? '' }}</span>
                                @if ($products->color_code)
                                    <span
                                        style="display:inline-block;width:16px;height:16px;border:1px solid #ccc;background-color:{{ $products->color_code }};margin-left:8px;border-radius:3px;"></span>
                                @endif
                            </div>
                        </div>
                        <div class="rs-product-description pl-16">
                            <div class="rs-product-description-content">
                                <h4 class="rs-product-description-title mb-16">
                                    {{ __('Description') }}
                                </h4>
                                <ul class="rs-product-description-text">

                                    {{ $products->description }}
                                </ul>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-md-12 col-12">
                    <div class="rs-product-location-area p-24" data-bg-color="#F6F7F9">
                        <a href="javascript:void(0)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="20" viewBox="0 0 18 20"
                                fill="none">
                                <path
                                    d="M9 0.25C4.175 0.25 0.25 4.175 0.25 9C0.25 14.118 4.94699 17.2199 8.05499 19.2729L8.584 19.624C8.71 19.708 8.855 19.75 9 19.75C9.145 19.75 9.29 19.708 9.416 19.624L9.94501 19.2729C13.053 17.2199 17.75 14.118 17.75 9C17.75 4.175 13.825 0.25 9 0.25ZM9.119 18.021L9 18.1001L8.881 18.021C5.871 16.033 1.75 13.311 1.75 9C1.75 5.002 5.002 1.75 9 1.75C12.998 1.75 16.25 5.002 16.25 9C16.25 13.311 12.128 16.034 9.119 18.021ZM9 5.75C7.208 5.75 5.75 7.208 5.75 9C5.75 10.792 7.208 12.25 9 12.25C10.792 12.25 12.25 10.792 12.25 9C12.25 7.208 10.792 5.75 9 5.75ZM9 10.75C8.035 10.75 7.25 9.965 7.25 9C7.25 8.035 8.035 7.25 9 7.25C9.965 7.25 10.75 8.035 10.75 9C10.75 9.965 9.965 10.75 9 10.75Z"
                                    fill="#DD5454" />
                            </svg>
                            {{ $location_name ?? 'Unknown Location' }}
                        </a>

                        <iframe class="br-8"
                            src="https://maps.google.com/maps?q={{ $products->latitude }},{{ $products->longitude }}&hl=es;z=15&output=embed"
                            width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- product info start -->
@endsection
@push('style')
    <style>
        @media (max-width: 399px) {
            .rs-promotadd-mobilebtn {
                flex: 0 0 100% !important;
            }
        }

        .rs-promotadd-mobilebtn.disabled {
            pointer-events: none;
            opacity: 0.8;

        }

        .rs-btn.disabled:hover {
            cursor: not-allowed;
        }
    </style>
@endpush
