@extends('web.profile.profile-master')
@section('my-ads-contnet')
    <!-- Error Modal -->
    <div id="errorModal" class="rs-payment-popup" style="display:none;">
        <div class="rs-payment-popup-content text-center p-relative">
            <button class="rs-payment-popup-close"><i class="fal fa-times"></i></button>
            <div class="rs-payment-popup-icon error mb-20">
                <img src="assets/img/icon/times-circle.svg" alt="">
            </div>
            <h2>{{ __('Something Went Wrong') }}</h2>
            <p>{{ __('Payment Failed') }} </p>
            <button class="rs-modal-btn rs-btn rs-error-btn actionBtn">{{ __('Try Again') }}</button>
        </div>
    </div>
    <div class="col-xl-12">
        <div class="rs-profile-head d-flex align-items-center justify-content-between br-8 p-16 mb-16"
            data-bg-color="#F6F7F9">
            <div class="profile-side-bar d-xl-none">
                <img src="{{ asset('assets/frontend/img/icon/side-bar-icon.svg') }}" alt="">
            </div>
            <h2 class="rs-profile-title">
                {{ __('My Ads') }}
            </h2>
            <button
                class="rs-btn rs-btn-2 rs-my-page-btn rs-product-offer-btn d-flex align-items-center justify-content-between rs-btn ml-auto mr-16
    {{ request()->routeIs('user.my-ads') && request()->has('all') ? 'active' : '' }}"
                onclick="window.location='{{ route('user.my-ads') }}?all=1'">
                {{ __('All Ads') }}
            </button>


            <button
                class="rs-my-page-btn rs-product-offer-btn my-adds-btn-2 rs-btn
        {{ optional(request()->route())->getName() === 'user.soldout' ? 'active' : '' }}"
                onclick="window.location='{{ route('user.soldout') }}?all=1'">
                {{ __('Sold out') }}
            </button>



        </div>
        <div class="row">
            @forelse ($products as $product)
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="rs-product-box rs-product-box-2">
                        <div class="rs-product-thumb p-relative">
                            <a class="popup-image" href="{{ $product->profilePath }}">
                                <img src="{{ $product->profilePath }}" alt="{{ $product->name }}">
                            </a>


                            <div class="rs-more-option p-absolute">
                                <a href="javascript:void(0)">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="5" height="20" viewBox="0 0 5 20"
                                        fill="none">
                                        <path
                                            d="M2.02063 4C0.91663 4 0.015625 3.104 0.015625 2C0.015625 0.896 0.90562 0 2.01062 0H2.02063C3.12463 0 4.02063 0.896 4.02063 2C4.02063 3.104 3.12563 4 2.02063 4ZM4.02063 10C4.02063 8.896 3.12463 8 2.02063 8H2.01062C0.90662 8 0.015625 8.896 0.015625 10C0.015625 11.104 0.91563 12 2.02063 12C3.12563 12 4.02063 11.104 4.02063 10ZM4.02063 18C4.02063 16.896 3.12463 16 2.02063 16H2.01062C0.90662 16 0.015625 16.896 0.015625 18C0.015625 19.104 0.91563 20 2.02063 20C3.12563 20 4.02063 19.104 4.02063 18Z"
                                            fill="#25314C" />
                                    </svg>
                                </a>
                                <div class="rs-more-option-item">
                                    <ul>
                                        @if ($product->status !== 'Soled')
                                            <li class="soldOutBtn" onclick="handleId({{ $product->id }})">
                                                <a href="javascript:void(0)">{{ __('Sold Out') }}</a>
                                            </li>



                                            <li>
                                                <form action="{{ route('product.auto-pay') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="selling_post_id"
                                                        value="{{ $product->id }}">
                                                    <button type="submit">
                                                        @if ($product->boostPost && $product->boostPost->auto_pay == 1)
                                                            {{ __('Off Auto Pay') }}
                                                        @else
                                                            {{ __('On Auto Pay') }}
                                                        @endif
                                                    </button>
                                                </form>
                                            </li>
                                        @endif

                                        <li>
                                            <form action="{{ route('product.makeCopy', $product->id) }}" method="POST">
                                                @csrf
                                                <button type="submit">{{ 'Make Copy' }}</button>
                                            </form>
                                        </li>

                                        <li>
                                            <form action="{{ route('selling-post.trash', $product->id) }}" method="POST">
                                                @csrf
                                                <button type="submit">{{ 'Move To Trash' }}</button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="rs-product-content">
                            <a href="{{ route('post-details', $product->id) }}"
                                class="d-flex align-items-center justify-content-between">
                                <h3 class="rs-product-title mb-8">{{ $product->name ?? 'Untitled Product' }}</h3>
                                <span class="rs-product-status">
                                    {{ $product->status }}
                                </span>
                            </a>

                            <div class="rs-product-price d-flex align-items-center justify-content-between mb-12">
                                <b>{{ currencyFormat($product->asking_price) ?? '$0.00' }}</b>
                                <span class="rs-product-time">
                                    {{ $product->created_at ? $product->created_at->diffForHumans() : 'Just now' }}
                                </span>

                            </div>
                            <div class="rs-product-btn d-flex align-items-center justify-content-between">
                                <a href="{{ route('product.edit', $product->id) }}"
                                    class="rs-product-details-btn d-flex align-items-center justify-content-center">
                                    {{ __('Edit Ads') }}
                                    <svg class="rotate-0" xmlns="http://www.w3.org/2000/svg" width="25" height="24"
                                        viewBox="0 0 25 24" fill="none">
                                        <path
                                            d="M21.77 13.72L20.78 12.73C20.47 12.42 20.0591 12.25 19.6221 12.25C19.6211 12.25 19.6201 12.25 19.6201 12.25C19.1821 12.25 18.7689 12.422 18.4609 12.733L12.97 18.249C12.829 18.389 12.751 18.58 12.751 18.778V21C12.751 21.414 13.087 21.75 13.501 21.75H15.7241C15.9221 21.75 16.1129 21.671 16.2529 21.531L21.769 16.04C22.08 15.731 22.25 15.319 22.251 14.881C22.25 14.443 22.08 14.031 21.77 13.72ZM19.6211 13.75C19.6471 13.75 19.685 13.757 19.719 13.791L20.709 14.781C20.743 14.815 20.75 14.854 20.75 14.88C20.75 14.906 20.743 14.944 20.709 14.978L20.073 15.611L18.8889 14.427L19.522 13.791C19.557 13.757 19.5951 13.75 19.6211 13.75ZM15.4131 20.25H14.25V19.087L17.8311 15.49L19.01 16.669L15.4131 20.25ZM10.5 19.25H6.5C4.923 19.25 4.25 18.577 4.25 17V5C4.25 3.423 4.923 2.75 6.5 2.75H11.75V5C11.75 7.418 13.082 8.75 15.5 8.75H17.75V10C17.75 10.414 18.086 10.75 18.5 10.75C18.914 10.75 19.25 10.414 19.25 10V8C19.25 7.801 19.171 7.61 19.03 7.47L13.03 1.47C12.889 1.329 12.699 1.25 12.5 1.25H6.5C4.082 1.25 2.75 2.582 2.75 5V17C2.75 19.418 4.082 20.75 6.5 20.75H10.5C10.914 20.75 11.25 20.414 11.25 20C11.25 19.586 10.914 19.25 10.5 19.25ZM13.25 5V3.811L16.689 7.25H15.5C13.923 7.25 13.25 6.577 13.25 5ZM7.5 10.25C7.086 10.25 6.75 10.586 6.75 11C6.75 11.414 7.086 11.75 7.5 11.75H14.5C14.914 11.75 15.25 11.414 15.25 11C15.25 10.586 14.914 10.25 14.5 10.25H7.5ZM11.5 14.25H7.5C7.086 14.25 6.75 14.586 6.75 15C6.75 15.414 7.086 15.75 7.5 15.75H11.5C11.914 15.75 12.25 15.414 12.25 15C12.25 14.586 11.914 14.25 11.5 14.25Z"
                                            fill="currentColor"></path>
                                    </svg>
                                </a>


                                @php
                                    $isApproved = $product->status === 'Approve';
                                @endphp

                                <a href="{{ $isApproved ? route('product.promote', $product->id) : 'javascript:void(0)' }}"
                                    class="rs-product-offer-btn rs-Promote-add-btn d-flex align-items-center justify-content-center rs-btn
                                      {{ !$isApproved ? 'disabled' : '' }}"
                                    {{ !$isApproved ? 'aria-disabled=true' : '' }}>
                                    @if ($product->activeBoost)
                                        @php
                                            $expires = \Carbon\Carbon::parse($product->activeBoost->expired_at);
                                        @endphp
                                        {{ __('Boosted (Expires: ' . $expires->format('d M') . ')') }}
                                    @else
                                        {{ __('Promote Ads') }}
                                    @endif

                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20"
                                        viewBox="0 0 21 20" fill="none">
                                        <path
                                            d="M19.2991 0.417495C18.7131 0.136495 18.0331 0.212522 17.5281 0.619522L16.496 1.4435C15.039 2.6095 13.209 3.25148 11.344 3.25148H5.99902C3.10402 3.25148 0.75 5.6065 0.75 8.5005C0.75 11.2285 2.84799 13.4505 5.51099 13.7005L7.776 18.2305C8.245 19.1685 9.18808 19.7505 10.2361 19.7505H11.499C11.72 19.7505 11.929 19.6535 12.071 19.4855C12.213 19.3175 12.275 19.0945 12.239 18.8775L11.385 13.7515C13.236 13.7615 15.049 14.4005 16.495 15.5575L17.525 16.3815C17.831 16.6255 18.198 16.7505 18.569 16.7505C18.816 16.7505 19.065 16.6955 19.298 16.5825C19.884 16.3015 20.248 15.7225 20.248 15.0725V1.9275C20.249 1.2785 19.8851 0.699495 19.2991 0.417495ZM2.24902 8.5005C2.24902 6.4335 3.93105 4.75148 5.99805 4.75148H11.343C12.158 4.75148 12.966 4.64649 13.749 4.44649V12.5545C12.966 12.3545 12.157 12.2495 11.343 12.2495H5.99805C3.93105 12.2495 2.24902 10.5675 2.24902 8.5005ZM10.235 18.2505C9.75799 18.2505 9.33007 17.9855 9.11707 17.5595L7.21204 13.7495H9.86304L10.613 18.2505H10.235ZM18.749 15.0725C18.749 15.1455 18.716 15.1995 18.649 15.2315C18.583 15.2625 18.518 15.2565 18.462 15.2105L17.432 14.3865C16.763 13.8515 16.027 13.4125 15.248 13.0725V3.92848C16.026 3.58848 16.762 3.14949 17.431 2.61549L18.463 1.79048C18.519 1.74548 18.581 1.73748 18.649 1.76948C18.694 1.79148 18.749 1.83648 18.749 1.92848V15.0725Z"
                                            fill="currentColor"></path>
                                    </svg>

                                </a>

                            </div>
                        </div>
                    </div>
                </div>

                <div id="soldOutModal" class="rs-product-make-offer" style="display:none;">
                    <div class="rs-product-make-offer-content text-center">
                        <button class="rs-product-make-offer-close" id="closeSoldOut">
                            <i class="fal fa-times"></i>
                        </button>
                        <h2 class="rs-sold-out-modal-title">{{ __('Great! Your Product is Sold') }}
                        </h2>
                        <h4 class="rs-sold-out-modal-sub-title">
                            {{ __('Just Complete the Form to Mark It as Sold') }}</h4>
                        <p>
                            {{ __("Here's a list of all the items you've successfully sold") }}.
                            {{ __('Keep track of your past listings and buyer activity') }}.
                        </p>

                        <form class="sold-out-form" action="{{ route('user.soldout-mark') }}" method="POST">
                            @csrf

                            <input type="text" id="product-ID" hidden name="product_id">

                            <div class="form-group mb-10 text-start">
                                <label for="buyerName" class="d-block mb-8">{{ __('Buyer Name') }}</label>
                                <input type="text" id="buyerName" name="buyer_name" placeholder="Enter Your Name">
                            </div>

                            <div class="sold-out-form-group d-flex align-items-center gap-16 mb-15 pb-15">
                                <div class="form-group w-100">
                                    <label for="soldPrice" class="d-block mb-8 text-start">{{ __('Sold Price') }}</label>
                                    <input type="number" id="soldPrice" name="sold_price"step="0.01" min="0"
                                        placeholder="Sold Price">
                                </div>

                                <div class="form-group w-100 position-relative">
                                    <label for="soldDate" class="d-block mb-8 text-start">{{ __('Date') }}</label>
                                    <input type="text" id="soldDate" name="sold_date" placeholder="mm/dd/yyyy"
                                        readonly class="flatpickr-input active">
                                    <span id="soldDateIcon" class="date-icon">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M15.75 1.5H14.5V0.75C14.5 0.336 14.164 0 13.75 0C13.336 0 13 0.336 13 0.75V1.5H6.5V0.75C6.5 0.336 6.164 0 5.75 0C5.336 0 5 0.336 5 0.75V1.5H3.75C1.332 1.5 0 2.832 0 5.25V15.75C0 18.168 1.332 19.5 3.75 19.5H15.75C18.168 19.5 19.5 18.168 19.5 15.75V5.25C19.5 2.832 18.168 1.5 15.75 1.5ZM3.75 3H5V3.75C5 4.164 5.336 4.5 5.75 4.5C6.164 4.5 6.5 4.164 6.5 3.75V3H13V3.75C13 4.164 13.336 4.5 13.75 4.5C14.164 4.5 14.5 4.164 14.5 3.75V3H15.75C17.327 3 18 3.673 18 5.25V6H1.5V5.25C1.5 3.673 2.173 3 3.75 3ZM15.75 18H3.75C2.173 18 1.5 17.327 1.5 15.75V7.5H18V15.75C18 17.327 17.327 18 15.75 18ZM6.77002 10.75C6.77002 11.302 6.32302 11.75 5.77002 11.75C5.21802 11.75 4.76489 11.302 4.76489 10.75C4.76489 10.198 5.20801 9.75 5.76001 9.75H5.77002C6.32202 9.75 6.77002 10.198 6.77002 10.75ZM10.77 10.75C10.77 11.302 10.323 11.75 9.77002 11.75C9.21802 11.75 8.76489 11.302 8.76489 10.75C8.76489 10.198 9.20801 9.75 9.76001 9.75H9.77002C10.322 9.75 10.77 10.198 10.77 10.75ZM14.77 10.75C14.77 11.302 14.323 11.75 13.77 11.75C13.218 11.75 12.7649 11.302 12.7649 10.75C12.7649 10.198 13.208 9.75 13.76 9.75H13.77C14.322 9.75 14.77 10.198 14.77 10.75ZM6.77002 14.75C6.77002 15.302 6.32302 15.75 5.77002 15.75C5.21802 15.75 4.76489 15.302 4.76489 14.75C4.76489 14.198 5.20801 13.75 5.76001 13.75H5.77002C6.32202 13.75 6.77002 14.198 6.77002 14.75ZM10.77 14.75C10.77 15.302 10.323 15.75 9.77002 15.75C9.21802 15.75 8.76489 15.302 8.76489 14.75C8.76489 14.198 9.20801 13.75 9.76001 13.75H9.77002C10.322 13.75 10.77 14.198 10.77 14.75ZM14.77 14.75C14.77 15.302 14.323 15.75 13.77 15.75C13.218 15.75 12.7649 15.302 12.7649 14.75C12.7649 14.198 13.208 13.75 13.76 13.75H13.77C14.322 13.75 14.77 14.198 14.77 14.75Z"
                                                fill="#17181D" />
                                        </svg>
                                    </span>
                                </div>
                            </div>

                            <div class="sold-out-btn d-flex align-items-center justify-content-center gap-20">
                                <button type="button" class="rs-sold-out-cancel-btn"
                                    id="cancelSoldOut">{{ __('Cancel') }}</button>
                                <button type="submit" class="rs-btn rs-sold-out-submit-btn">{{ __('Submit') }}</button>
                            </div>
                        </form>

                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="text-center p-40 br-8" data-bg-color="#F6F7F9">
                        <h4 class="mb-8">{{ __('No Post Found') }}</h4>
                        <p class="text-muted">
                            {{ __('You have not posted any ads yet.') }}
                        </p>
                    </div>
                </div>
            @endforelse

        </div>
    </div>
@endsection

@push('styles')
    <style>
        .rs-btn.disabled {
            pointer-events: none;
            opacity: 0.5;

        }

        .rs-btn.active {
            background-color: var(--tp-red-color);
            color: #fff;
        }


        /* Cursor color trick (visual red effect) */
        .rs-btn.disabled:hover {
            cursor: not-allowed;
        }
    </style>
@endpush


@push('script')
    <script>
        const handleId = (id) => {
            $productInput = document.querySelector('#product-ID');
            $productInput.value = id;
        }
    </script>

    {{-- model --}}
    @if (session('success') || session('error'))
        <script>
            const successModal = document.getElementById('successModal');
            const errorModal = document.getElementById('errorModal');

            @if (session('success'))
                successModal.style.display = 'flex';
            @elseif (session('error'))
                errorModal.style.display = 'flex';
            @endif

            function closeModal() {
                successModal.style.display = 'none';
                errorModal.style.display = 'none';

            }

            document.querySelectorAll('.rs-payment-popup-close, .actionBtn').forEach(btn => {
                btn.addEventListener('click', closeModal);
            });

            overlay.addEventListener('click', closeModal);
        </script>
    @endif
@endpush
