@extends('web.profile.profile-master')
@section('notification-content')
    <div class="">
        <div class="rs-profile-head d-flex align-items-center justify-content-between br-8 p-16 mb-16"
            data-bg-color="#F6F7F9">
            <div class="profile-side-bar d-xl-none">
                <img src="{{ asset('assets/frontend/img/icon/side-bar-icon.svg') }}" alt="">
            </div>
            <h2 class="rs-profile-title">
                {{ __('Notification') }}
            </h2>
            <a href="{{ route('user.read-all-notifications') }}"
                class="rs-notification-btn d-flex align-items-center justify-content-between rs-btn rs-btn-2">
                {{ __('Read All') }}
            </a>
        </div>


        @foreach ($notifications as $notification)
            <div class="notification-item d-flex gap-12 p-16 p-relative
        {{ $notification->is_read ? 'rs-notification-card-read' : 'rs-notification-card-unread' }}"
                data-notification="{{ $notification->id }}">

                {{-- Left: Logo --}}
                <div class="rs-notification-logo flex-shrink-0">
                    <img src="{{ $notification->notificationSender->profilePhotoPath ?? '' }}" alt="">
                </div>

                {{-- Middle: Content --}}
                <div class="rs-notification-content flex-grow-1">
                    <h4 class="rs-notification-title mb-4">
                        {{ $notification->subject }}
                    </h4>
                    <p class="rs-notification-text mb-0">
                        {{ $notification->body }}
                    </p>
                </div>

                {{-- Right: Date --}}
                <div class="rs-notification-date text-end">
                    {{ $notification->created_at->format('jS F Y') }}
                </div>
            </div>
        @endforeach


    </div>

    {{ $notifications->links() }}
@endsection
@push('script')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const notifications = document.querySelectorAll('.notification-item');

    notifications.forEach(notification => {
        notification.addEventListener('click', function () {
            const notificationId = notification.getAttribute('data-notification');

            // Step 1: Instantly add read class
            notification.classList.remove("rs-notification-card-unread");
            notification.classList.add("rs-notification-card-read");

            // Step 2: Database update aar redirect
            axios.post("{{ route('user.notification.read') }}", {
                notification_id: notificationId
            })
            .then(response => {
                window.location.href = response.data.redirect_url;
            })
            .catch(error => {
                console.error("Something went wrong", error);
            });
        });
    });
});
</script>


@endpush
