<div class="rs-profile-offcanvas">
    <div class="col-xl-4">
        <div class="rs-profile-side-bar">
            <div class="rs-profile-side-bar-head d-flex align-items-center br-8" data-bg-color="#F6F7F9">
                <div class="rs-profile-side-bar-profile-img mr-12">
                    <a href="javascript:void(0)" class="rs-profile-img-add rs-profile-img-add-2">
                        <img class="br-100" src="{{ auth()->user()->profilePhotoPath ?? 'https://placehold.co/600x400' }}" alt="">
                    </a>
                </div>
                <div class="rs-profile-user-info mr-6 d-flex flex-column">
                    <a href="javascript:void(0)" class="rs-profile-user-name">
                        {{ auth()->user()->name ?? '' }}
                    </a>
                    <a href="mailto:{{ auth()->user()->email ?? '' }}" class="rs-profile-user-email">
                        {{ \Illuminate\Support\Str::limit(auth()->user()->email ?? '', 20, '...') }}
                    </a>
                </div>
                <div class="rs-profile-user-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M17.1221 6.87926L16.6812 6.43825C16.4002 6.15725 16.2421 5.77524 16.2421 5.37724V4.75624C16.2421 3.10024 14.9002 1.75825 13.2442 1.75825H12.6232C12.2252 1.75825 11.8442 1.60026 11.5622 1.31926L11.1212 0.87825C9.95017 -0.29275 8.05218 -0.29275 6.88118 0.87825L6.44014 1.31926C6.15914 1.60026 5.77723 1.75825 5.37923 1.75825H4.75826C3.10225 1.75825 1.76021 3.10024 1.76021 4.75624V5.37724C1.76021 5.77524 1.60224 6.15625 1.32124 6.43825L0.880203 6.87926C-0.290797 8.05026 -0.290797 9.94825 0.880203 11.1192L1.32124 11.5603C1.60224 11.8413 1.76021 12.2233 1.76021 12.6213V13.2423C1.76021 14.8983 3.10225 16.2402 4.75826 16.2402H5.37923C5.77723 16.2402 6.15814 16.3982 6.44014 16.6792L6.88118 17.1203C8.05218 18.2913 9.95017 18.2913 11.1212 17.1203L11.5622 16.6792C11.8432 16.3982 12.2252 16.2402 12.6232 16.2402H13.2442C14.9002 16.2402 16.2421 14.8983 16.2421 13.2423V12.6213C16.2421 12.2233 16.4002 11.8423 16.6812 11.5603L17.1221 11.1192C18.2931 9.94825 18.2931 8.05026 17.1221 6.87926ZM12.5302 7.52925L8.53023 11.5293C8.38423 11.6753 8.1922 11.7493 8.0002 11.7493C7.8082 11.7493 7.61617 11.6763 7.47017 11.5293L5.47017 9.52925C5.17717 9.23625 5.17717 8.76125 5.47017 8.46825C5.76317 8.17525 6.2382 8.17525 6.5312 8.46825L8.00117 9.93825L11.4711 6.46825C11.7641 6.17525 12.2392 6.17525 12.5322 6.46825C12.8232 6.76125 12.8232 7.23725 12.5302 7.52925Z"
                            fill="#067BFF" />
                    </svg>
                </div>
                <div id="ProfileOff" class="tp-offcanvas-close ml-auto-start" data-bg-color="#fff">
                    <button>
                        <i class="fal fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="rs-profile-side-bar-body p-16 pt-8">
                <div class="rs-profile-side-bar-list">
                    <ul>
                        <!-- My Profile -->
                        <li class="{{ request()->routeIs('user.profile') ? 'active' : '' }}">
                            <a href="{{ route('user.profile') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="20" viewBox="0 0 16 20" fill="none">
                                    <path d="M4.00903 4.5C4.00903 2.294 5.80303 0.5 8.00903 0.5C10.215 0.5 12.009 2.294 12.009 4.5C12.009 6.706 10.215 8.5 8.00903 8.5C5.80303 8.5 4.00903 6.706 4.00903 4.5ZM10 10.5H6C1.94 10.5 0.5 13.473 0.5 16.019C0.5 18.296 1.71105 19.5 4.00305 19.5H11.9969C14.2889 19.5 15.5 18.296 15.5 16.019C15.5 13.473 14.06 10.5 10 10.5Z" fill="currentColor" />
                                </svg>
                                {{ __('My Profile') }}
                            </a>
                        </li>

                        <!-- My Wallet -->
                        <li class="{{ request()->routeIs('user.my-wallet') ? 'active' : '' }}">
                            <a href="{{ route('user.my-wallet') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M10.25 11C10.25 12.79 11.71 14.25 13.5 14.25H18V15C18 17 17 18 15 18H3C1 18 0 17 0 15V2C0 3.1 0.9 4 2 4H15C17 4 18 5 18 7V7.75H13.5C11.71 7.75 10.25 9.21 10.25 11ZM13.5 9.25C12.54 9.25 11.75 10.04 11.75 11C11.75 11.96 12.54 12.75 13.5 12.75H18V9.25H13.5ZM14.02 12C13.47 12 13.01 11.55 13.01 11C13.01 10.45 13.46 10 14.01 10H14.02C14.57 10 15.02 10.45 15.02 11C15.02 11.55 14.57 12 14.02 12ZM12 0H2.75C2.06 0 1.5 0.56 1.5 1.25C1.5 1.94 2.06 2.5 2.75 2.5H14.97C14.82 0.83 13.83 0 12 0Z" fill="currentColor" />
                                </svg>
                                {{ __('My Wallet') }}
                            </a>
                        </li>

                        <!-- My Ads -->
                        <li class="{{ request()->routeIs(['user.my-ads', 'product.promote', 'product.promote.checkout']) ? 'active' : '' }}">
                            <a href="{{ route('user.my-ads') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18" fill="none">
                                    <path d="M13 0H3C1 0 0 1 0 3V15C0 17 1 18 3 18H13C15 18 16 17 16 15V3C16 1 15 0 13 0ZM6.03003 12.864L4.69702 14.197C4.55102 14.343 4.35899 14.417 4.16699 14.417C3.97599 14.417 3.78296 14.344 3.63696 14.198L2.96997 13.531C2.67697 13.238 2.67697 12.763 2.96997 12.47C3.26197 12.178 3.73701 12.177 4.03101 12.47L4.16797 12.607L4.97095 11.804C5.26395 11.511 5.73898 11.511 6.03198 11.804C6.32498 12.097 6.32303 12.571 6.03003 12.864ZM6.03003 8.86401L4.69702 10.197C4.55102 10.343 4.35899 10.417 4.16699 10.417C3.97599 10.417 3.78296 10.344 3.63696 10.198L2.96997 9.53101C2.67697 9.23801 2.67697 8.76297 2.96997 8.46997C3.26197 8.17797 3.73701 8.17697 4.03101 8.46997L4.16797 8.60699L4.97095 7.80402C5.26395 7.51102 5.73898 7.51102 6.03198 7.80402C6.32498 8.09702 6.32303 8.57101 6.03003 8.86401ZM6.03003 4.86401L4.69702 6.19702C4.55102 6.34302 4.35899 6.41699 4.16699 6.41699C3.97599 6.41699 3.78296 6.344 3.63696 6.198L2.96997 5.53101C2.67697 5.23801 2.67697 4.76297 2.96997 4.46997C3.26197 4.17797 3.73701 4.17697 4.03101 4.46997L4.16797 4.60699L4.97095 3.80402C5.26395 3.51102 5.73898 3.51102 6.03198 3.80402C6.32498 4.09702 6.32303 4.57101 6.03003 4.86401ZM12.5 13.75H8.5C8.086 13.75 7.75 13.414 7.75 13C7.75 12.586 8.086 12.25 8.5 12.25H12.5C12.914 12.25 13.25 12.586 13.25 13C13.25 13.414 12.914 13.75 12.5 13.75ZM12.5 9.75H8.5C8.086 9.75 7.75 9.414 7.75 9C7.75 8.586 8.086 8.25 8.5 8.25H12.5C12.914 8.25 13.25 8.586 13.25 9C13.25 9.414 12.914 9.75 12.5 9.75ZM12.5 5.75H8.5C8.086 5.75 7.75 5.414 7.75 5C7.75 4.586 8.086 4.25 8.5 4.25H12.5C12.914 4.25 13.25 4.586 13.25 5C13.25 5.414 12.914 5.75 12.5 5.75Z" fill="currentColor" />
                                </svg>
                                {{ __('My Ads') }}
                            </a>
                        </li>

                        <!-- Wishlist -->
                        <li class="{{ request()->routeIs('user.show-wishlist') ? 'active' : '' }}">
                            <a href="{{ route('user.show-wishlist') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M10 0C4.477 0 0 4.477 0 10C0 15.523 4.477 20 10 20C15.523 20 20 15.523 20 10C20 4.477 15.523 0 10 0ZM14.675 9.95203C14.054 13.155 10 15 10 15C10 15 5.94595 13.155 5.32495 9.95203C4.94395 7.98703 5.77604 6.01 7.89404 6C9.47104 5.992 10 7.58197 10 7.58197C10 7.58197 10.529 5.992 12.106 6C14.228 6.01 15.056 7.98703 14.675 9.95203Z" fill="currentColor" />
                                </svg>
                                {{ __('Wishlist') }}
                            </a>
                        </li>

                        <!-- Messages -->
                        <li class="{{ request()->routeIs('chat.index') ? 'active' : '' }}">
                            <a href="{{ route('chat.index') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                    <path d="M14.0205 9.33301V2.33301C14.0205 0.778008 13.2425 0 11.6875 0H2.35449C0.798492 0 0.0214844 0.778008 0.0214844 2.33301V14L2.35449 11.667H11.6875C13.2425 11.667 14.0205 10.889 14.0205 9.33301ZM4.02051 7C3.46851 7 3.01538 6.552 3.01538 6C3.01538 5.448 3.4585 5 4.0105 5H4.02051C4.57351 5 5.02051 5.448 5.02051 6C5.02051 6.552 4.57251 7 4.02051 7ZM7.02051 7C6.46851 7 6.01538 6.552 6.01538 6C6.01538 5.448 6.4585 5 7.0105 5H7.02051C7.57351 5 8.02051 5.448 8.02051 6C8.02051 6.552 7.57251 7 7.02051 7ZM10.0205 7C9.46851 7 9.01538 6.552 9.01538 6C9.01538 5.448 9.4585 5 10.0105 5H10.0205C10.5735 5 11.0205 5.448 11.0205 6C11.0205 6.552 10.5725 7 10.0205 7ZM18.0205 8V18L16.0205 16H8.02051C6.69051 16 6.02051 15.33 6.02051 14C6.02051 14 6.02051 13.72 6.02051 13.479C6.02051 13.266 6.18144 13.17 6.32544 13.17C6.42544 13.17 11.6904 13.17 11.6904 13.17C14.0904 13.17 15.5205 11.73 15.5205 9.32996C15.5205 9.32996 15.5205 6.53305 15.5205 6.30005C15.5205 6.06705 15.7236 6 15.8186 6C15.9126 6 16.0205 6 16.0205 6C17.3505 6 18.0205 6.67 18.0205 8Z" fill="currentColor" />
                                </svg>
                                {{ __('Messages') }}
                                <cite>2</cite>
                            </a>
                        </li>

                        <!-- Notifications -->
                        <li class="{{ request()->routeIs('user.show-notifications') ? 'active' : '' }}">
                            <a href="{{ route('user.show-notifications') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M18.4499 16.2179C18.3669 16.3909 18.1919 16.5009 17.9999 16.5009H1.99991C1.80791 16.5009 1.6329 16.3909 1.5499 16.2179C1.4669 16.0449 1.4899 15.8389 1.6099 15.6889C1.6289 15.6659 3.50593 13.2829 3.50593 10.5009V6.99588C3.50593 3.41488 6.41992 0.50088 10.0009 0.50088C13.5819 0.50088 16.4959 3.41488 16.4959 6.99588V10.5009C16.4959 13.2819 18.3719 15.6649 18.3919 15.6889C18.5099 15.8389 18.5339 16.0439 18.4499 16.2179ZM1.74592 6.07588C1.91692 4.36688 2.60693 2.78387 3.74293 1.49787C4.01693 1.18687 3.98692 0.712884 3.67692 0.438884C3.36592 0.163884 2.89193 0.193878 2.61793 0.504878C1.27393 2.02788 0.455912 3.90288 0.253912 5.92688C0.211912 6.33888 0.512902 6.70687 0.924902 6.74787C0.949902 6.74987 0.975922 6.75189 1.00092 6.75189C1.38092 6.75089 1.70792 6.46188 1.74592 6.07588ZM19.0749 6.74688C19.4869 6.70588 19.7879 6.33788 19.7459 5.92588C19.5439 3.90288 18.7259 2.02789 17.3819 0.503886C17.1089 0.193886 16.6339 0.162877 16.3229 0.437877C16.0119 0.711877 15.9829 1.18588 16.2569 1.49688C17.3919 2.78288 18.0829 4.36589 18.2539 6.07489C18.2929 6.46189 18.6189 6.74987 18.9989 6.74987C19.0239 6.75087 19.0489 6.74988 19.0749 6.74688ZM12.1639 17.7519C12.0749 17.5969 11.9099 17.5009 11.7299 17.5009H8.2699C8.0909 17.5009 7.92591 17.5969 7.83591 17.7519C7.74591 17.9069 7.74793 18.0989 7.83793 18.2529C8.29393 19.0339 9.10191 19.5009 9.99991 19.5009C10.8979 19.5009 11.7059 19.0339 12.1619 18.2529C12.2519 18.0989 12.2529 17.9069 12.1639 17.7519Z" fill="currentColor" />
                                </svg>
                                {{ __('Notification') }}
                                <cite>{{ getUnreadNotificationsCount(true) }}</cite>
                            </a>
                        </li>

                        <!-- Payment History -->
                        <li class="{{ request()->routeIs('user.payment-history') ? 'active' : '' }}">
                            <a href="{{ route('user.payment-history') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="19" height="21" viewBox="0 0 19 21" fill="none">
                                    <path d="M3 21H1C0.448 21 0 20.552 0 20V16C0 15.448 0.448 15 1 15H3C3.552 15 4 15.448 4 16V20C4 20.552 3.552 21 3 21ZM17.66 15.02C17.43 15.02 17.2 15.08 16.98 15.21L14.71 16.5699C14.5 17.7999 13.42 18.75 12.12 18.75H9C8.59 18.75 8.25 18.41 8.25 18C8.25 17.59 8.59 17.25 9 17.25H12.12C12.74 17.25 13.25 16.75 13.25 16.12C13.25 15.5 12.74 15 12.12 15H7C5.9 15 5 15.9 5 17V19C5 20.1 5.9 21 7 21H12.6C13.51 21 14.39 20.69 15.1 20.12L18.5 17.4C18.82 17.15 19 16.76 19 16.36C19 15.58 18.36 15.02 17.66 15.02ZM16 6.5C16 9.809 13.309 12.5 10 12.5C6.691 12.5 4 9.809 4 6.5C4 3.191 6.691 0.5 10 0.5C13.309 0.5 16 3.191 16 6.5ZM12.25 7.91199C12.25 6.96999 11.626 6.14894 10.731 5.91394L9.646 5.63403C9.535 5.60503 9.43801 5.53894 9.36301 5.43994C9.29001 5.34394 9.25 5.21901 9.25 5.08801C9.25 4.77901 9.48001 4.52698 9.76401 4.52698H10.237C10.497 4.52698 10.717 4.74102 10.748 5.02502C10.792 5.43702 11.157 5.73194 11.575 5.68994C11.987 5.64594 12.284 5.27504 12.24 4.86304C12.146 3.99204 11.531 3.307 10.737 3.099V2.99902C10.737 2.58502 10.401 2.24902 9.987 2.24902C9.573 2.24902 9.237 2.58502 9.237 2.99902V3.10803C8.384 3.34703 7.75201 4.13904 7.75201 5.08704C7.75201 5.54404 7.90101 5.99004 8.16901 6.34204C8.44201 6.70604 8.833 6.96898 9.272 7.08398L10.357 7.36401C10.59 7.42501 10.753 7.65003 10.753 7.91003C10.753 8.06303 10.696 8.20696 10.593 8.31396C10.536 8.37296 10.416 8.46997 10.239 8.46997H9.76599C9.50599 8.46997 9.28601 8.25605 9.255 7.97205C9.21101 7.56005 8.84701 7.26401 8.42801 7.30701C8.01601 7.35101 7.719 7.72203 7.763 8.13403C7.856 8.99303 8.45599 9.67104 9.23599 9.88904V10C9.23599 10.414 9.57199 10.75 9.98599 10.75C10.4 10.75 10.736 10.414 10.736 10V9.90002C11.085 9.80802 11.408 9.62806 11.67 9.35706C12.044 8.96906 12.25 8.45499 12.25 7.91199Z" fill="currentColor" />
                                </svg>
                                {{ __('Payment History') }}
                            </a>
                        </li>

                        <!-- Review -->
                        <li class="{{ request()->routeIs('user.review-index') ? 'active' : '' }}">
                            <a href="{{ route('user.review-index') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M14.625 0H3.375C1.125 0 0 1.125 0 3.375V14.625C0 16.875 1.125 18 3.375 18H14.625C16.875 18 18 16.875 18 14.625V3.375C18 1.125 16.875 0 14.625 0ZM13.8311 8.39301L12.031 10.15C11.899 10.278 11.839 10.464 11.87 10.645L12.282 13.05C12.365 13.538 11.8549 13.91 11.4189 13.68L9.25903 12.543C9.09703 12.458 8.90394 12.458 8.74194 12.543L6.58398 13.679C6.14598 13.909 5.63599 13.536 5.71899 13.048L6.13098 10.645C6.16198 10.463 6.10197 10.278 5.96997 10.15L4.17004 8.39301C3.83904 8.07001 4.02103 7.507 4.47803 7.44L6.96802 7.078C7.14902 7.052 7.30596 6.93701 7.38696 6.77301L8.46594 4.58398C8.68494 4.13998 9.31603 4.13998 9.53503 4.58398L10.614 6.77301C10.695 6.93801 10.852 7.052 11.033 7.078L13.5229 7.44C13.9799 7.506 14.1621 8.07001 13.8311 8.39301Z" fill="currentColor" />
                                </svg>
                                {{ __('Review') }}
                            </a>
                        </li>

                        <!-- Language -->
                        <li class="rs-profile-language">
                            @php
                                $currentLang = $languages->firstWhere('name', session('locale', config('app.locale'))) ?? $languages->first();
                                $currentImg = $currentLang && $currentLang->thumbnail ? asset('storage/' . $currentLang->thumbnail->src) : asset('assets/img/flag/flag-01.svg');
                            @endphp
                            <a href="javascript:void(0)" class="d-flex align-items-center gap-15" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fal fa-globe"></i> {{ __('Language') }}
                                <div class="rs-profile-lang d-flex align-items-center gap-13 w-50 justify-content-end">
                                    <img src="{{ $currentImg }}" alt="{{ $currentLang->title ?? 'Language' }}" width="20" height="20" style="object-fit: cover; border-radius: 3px;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="10" height="6" viewBox="0 0 10 6" fill="none">
                                        <path d="M4.99978 5.75076C4.80778 5.75076 4.61575 5.67778 4.46975 5.53079L0.46975 1.53079C0.17675 1.23779 0.17675 0.76275 0.46975 0.46975C0.76275 0.17675 1.23779 0.17675 1.53079 0.46975L5.00076 3.93972L8.47073 0.46975C8.76373 0.17675 9.23876 0.17675 9.53176 0.46975C9.82476 0.76275 9.82476 1.23779 9.53176 1.53079L5.53176 5.53079C5.38376 5.67778 5.19178 5.75076 4.99978 5.75076Z" fill="currentColor" />
                                    </svg>
                                </div>
                            </a>
                            <ul class="rs-profile-lang-menu" style="background:transparent; padding-left:40px">
                                @foreach ($languages as $language)
                                    <li>
                                        <a href="{{ route('change.language', ['language' => $language->name]) }}"
                                           class="d-flex align-items-center gap-2 {{ session('locale') === $language->name ? 'active' : '' }}"
                                           style="color:#17181D !important">
                                            <img src="{{ $language->thumbnail ? asset('storage/' . $language->thumbnail->src) : asset('assets/img/flag/default-flag.svg') }}"
                                                 alt="{{ $language->title }}" width="20" height="20"
                                                 style="object-fit: cover; border-radius: 3px;">
                                            <span>{{ $language->title }}</span>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>

                        <!-- Trash -->
                        <li class="{{ request()->routeIs('user.trash-index') ? 'active' : '' }}">
                            <a href="{{ route('user.trash-index') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M15.56 4.75H2.44C2.267 4.75 2.12899 4.89701 2.14099 5.07001L2.81 15.2C2.92 16.78 3.75 18 5.81 18H12.19C14.25 18 15.08 16.78 15.19 15.2L15.859 5.07001C15.87 4.89701 15.733 4.75 15.56 4.75ZM11.5 11.75H6.5C6.086 11.75 5.75 11.414 5.75 11C5.75 10.586 6.086 10.25 6.5 10.25H11.5C11.914 10.25 12.25 10.586 12.25 11C12.25 11.414 11.914 11.75 11.5 11.75ZM17.75 3C17.75 3.414 17.414 3.75 17 3.75H1C0.586 3.75 0.25 3.414 0.25 3C0.25 2.586 0.586 2.25 1 2.25H5.21399C5.30699 2.068 5.37899 1.862 5.45599 1.632L5.65799 1.02499C5.86199 0.412994 6.43499 0 7.08099 0H10.919C11.565 0 12.138 0.412994 12.342 1.02499L12.544 1.632C12.621 1.862 12.693 2.068 12.786 2.25H17C17.414 2.25 17.75 2.586 17.75 3Z" fill="currentColor" />
                                </svg>
                                {{ __('Trash') }}
                            </a>
                        </li>

                        <!-- Change Password -->
                        <li class="{{ request()->routeIs('user.change-password-index') ? 'active' : '' }}">
                            <a href="{{ route('user.change-password-index') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M12 0C8.69 0 6 2.69 6 6C6 6.61 6.09001 7.18999 6.26001 7.73999L0 14V18H4V15H7L10.26 11.74C10.81 11.91 11.39 12 12 12C15.31 12 18 9.31 18 6C18 2.69 15.31 0 12 0ZM13.02 6.25C12.331 6.25 11.7649 5.69 11.7649 5C11.7649 4.31 12.32 3.75 13.01 3.75H13.02C13.71 3.75 14.27 4.31 14.27 5C14.27 5.69 13.71 6.25 13.02 6.25Z" fill="currentColor" />
                                </svg>
                                {{ __('Change Password') }}
                            </a>
                        </li>

                        <!-- Logout -->
                        <li>
                            <form action="{{ route('user.logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="d-flex align-items-center gap-15" style="background: none; border: none; width: 100%; text-align: left; padding: 0; color: inherit;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                        <path d="M5 9.75H12V14V15C12 17 11 18 9 18H3C1 18 0 17 0 15V3C0 1 1 0 3 0H9C11 0 12 1 12 3V4V8.25H5C4.586 8.25 4.25 8.586 4.25 9C4.25 9.414 4.586 9.75 5 9.75ZM18.692 8.71301C18.654 8.62101 18.599 8.53799 18.53 8.46899L15.53 5.46899C15.237 5.17599 14.762 5.17599 14.469 5.46899C14.176 5.76199 14.176 6.237 14.469 6.53L16.189 8.25H12V9.75H16.189L14.469 11.47C14.176 11.763 14.176 12.238 14.469 12.531C14.615 12.677 14.807 12.751 14.999 12.751C15.191 12.751 15.383 12.678 15.529 12.531L18.529 9.53101C18.598 9.46201 18.653 9.37899 18.691 9.28699C18.768 9.10299 18.768 8.89701 18.692 8.71301Z" fill="currentColor" />
                                    </svg>
                                    {{ __('Logout') }}
                                </button>
                            </form>
                        </li>

                        <!-- Delete Account -->
                        <li>
                            <a href="{{ route('user.show-delete-account') }}" class="d-flex align-items-center gap-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M17.75 3C17.75 3.414 17.414 3.75 17 3.75H1C0.586 3.75 0.25 3.414 0.25 3C0.25 2.586 0.586 2.25 1 2.25H5.214C5.307 2.068 5.37899 1.862 5.45599 1.632L5.658 1.02499C5.862 0.412994 6.43499 0 7.08099 0H10.919C11.565 0 12.138 0.412994 12.342 1.02499L12.544 1.632C12.621 1.862 12.693 2.068 12.786 2.25H17C17.414 2.25 17.75 2.586 17.75 3ZM15.56 4.75C15.733 4.75 15.871 4.89701 15.859 5.07001L15.19 15.2C15.08 16.78 14.25 18 12.19 18H5.81C3.75 18 2.92 16.78 2.81 15.2L2.141 5.07001C2.13 4.89701 2.267 4.75 2.44 4.75H15.56ZM7.75 8C7.75 7.59 7.41 7.25 7 7.25C6.59 7.25 6.25 7.59 6.25 8V13C6.25 13.41 6.59 13.75 7 13.75C7.41 13.75 7.75 13.41 7.75 13V8ZM11.75 8C11.75 7.59 11.41 7.25 11 7.25C10.59 7.25 10.25 7.59 10.25 8V13C10.25 13.41 10.59 13.75 11 13.75C11.41 13.75 11.75 13.41 11.75 13V8Z" fill="currentColor" />
                                </svg>
                                {{ __('Delete Account') }}
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>