
# Vault Response Customer

This object defines a customer in your system. Use it to manage customer profiles, save payment methods and contact details.

## Structure

`VaultResponseCustomer`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | The unique ID for a customer generated by PayPal.<br><br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `22`, *Pattern*: `^[0-9a-zA-Z_-]+$` | getId(): ?string | setId(?string id): void |
| `merchantCustomerId` | `?string` | Optional | Merchants and partners may already have a data-store where their customer information is persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your representation of a customer.<br><br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `64`, *Pattern*: `^[0-9a-zA-Z-_.^*$@#]+$` | getMerchantCustomerId(): ?string | setMerchantCustomerId(?string merchantCustomerId): void |
| `links` | `array` | Optional | DEPRECATED. This field is DEPRECATED.<br><br>**Constraints**: *Maximum Items*: `16` | getLinks(): array | setLinks(array links): void |

## Example (as JSON)

```json
{
  "id": "id4",
  "merchant_customer_id": "merchant_customer_id6",
  "links": [
    {
      "key1": "val1",
      "key2": "val2"
    },
    {
      "key1": "val1",
      "key2": "val2"
    }
  ]
}
```

