<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The activate subscription request details.
 */
class ActivateSubscriptionRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $reason;

    /**
     * Returns Reason.
     * The reason for activation of a subscription. Required to reactivate the subscription.
     */
    public function getReason(): ?string
    {
        return $this->reason;
    }

    /**
     * Sets Reason.
     * The reason for activation of a subscription. Required to reactivate the subscription.
     *
     * @maps reason
     */
    public function setReason(?string $reason): void
    {
        $this->reason = $reason;
    }

    /**
     * Converts the ActivateSubscriptionRequest object to a human-readable string representation.
     *
     * @return string The string representation of the ActivateSubscriptionRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('ActivateSubscriptionRequest', ['reason' => $this->reason]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->reason)) {
            $json['reason'] = $this->reason;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
