<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CaptureSubscriptionRequest;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model CaptureSubscriptionRequest
 *
 * @see CaptureSubscriptionRequest
 */
class CaptureSubscriptionRequestBuilder
{
    /**
     * @var CaptureSubscriptionRequest
     */
    private $instance;

    private function __construct(CaptureSubscriptionRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Capture Subscription Request Builder object.
     *
     * @param string $note
     * @param string $captureType
     * @param Money $amount
     */
    public static function init(string $note, string $captureType, Money $amount): self
    {
        return new self(new CaptureSubscriptionRequest($note, $captureType, $amount));
    }

    /**
     * Initializes a new Capture Subscription Request object.
     */
    public function build(): CaptureSubscriptionRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
