<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CycleExecution;

/**
 * Builder for model CycleExecution
 *
 * @see CycleExecution
 */
class CycleExecutionBuilder
{
    /**
     * @var CycleExecution
     */
    private $instance;

    private function __construct(CycleExecution $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Cycle Execution Builder object.
     *
     * @param string $tenureType
     * @param int $sequence
     * @param int $cyclesCompleted
     */
    public static function init(string $tenureType, int $sequence, int $cyclesCompleted): self
    {
        return new self(new CycleExecution($tenureType, $sequence, $cyclesCompleted));
    }

    /**
     * Sets cycles remaining field.
     *
     * @param int|null $value
     */
    public function cyclesRemaining(?int $value): self
    {
        $this->instance->setCyclesRemaining($value);
        return $this;
    }

    /**
     * Sets current pricing scheme version field.
     *
     * @param int|null $value
     */
    public function currentPricingSchemeVersion(?int $value): self
    {
        $this->instance->setCurrentPricingSchemeVersion($value);
        return $this;
    }

    /**
     * Sets total cycles field.
     *
     * @param int|null $value
     */
    public function totalCycles(?int $value): self
    {
        $this->instance->setTotalCycles($value);
        return $this;
    }

    /**
     * Initializes a new Cycle Execution object.
     */
    public function build(): CycleExecution
    {
        return CoreHelper::clone($this->instance);
    }
}
