<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\ModifySubscriptionResponse;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PlanOverride;
use PaypalServerSdkLib\Models\ShippingDetails;

/**
 * Builder for model ModifySubscriptionResponse
 *
 * @see ModifySubscriptionResponse
 */
class ModifySubscriptionResponseBuilder
{
    /**
     * @var ModifySubscriptionResponse
     */
    private $instance;

    private function __construct(ModifySubscriptionResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Modify Subscription Response Builder object.
     */
    public static function init(): self
    {
        return new self(new ModifySubscriptionResponse());
    }

    /**
     * Sets plan id field.
     *
     * @param string|null $value
     */
    public function planId(?string $value): self
    {
        $this->instance->setPlanId($value);
        return $this;
    }

    /**
     * Sets quantity field.
     *
     * @param string|null $value
     */
    public function quantity(?string $value): self
    {
        $this->instance->setQuantity($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets shipping address field.
     *
     * @param ShippingDetails|null $value
     */
    public function shippingAddress(?ShippingDetails $value): self
    {
        $this->instance->setShippingAddress($value);
        return $this;
    }

    /**
     * Sets plan field.
     *
     * @param PlanOverride|null $value
     */
    public function plan(?PlanOverride $value): self
    {
        $this->instance->setPlan($value);
        return $this;
    }

    /**
     * Sets plan overridden field.
     *
     * @param bool|null $value
     */
    public function planOverridden(?bool $value): self
    {
        $this->instance->setPlanOverridden($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Modify Subscription Response object.
     */
    public function build(): ModifySubscriptionResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
