<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaypalWalletVaultBase;

/**
 * Builder for model PaypalWalletVaultBase
 *
 * @see PaypalWalletVaultBase
 */
class PaypalWalletVaultBaseBuilder
{
    /**
     * @var PaypalWalletVaultBase
     */
    private $instance;

    private function __construct(PaypalWalletVaultBase $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Paypal Wallet Vault Base Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWalletVaultBase());
    }

    /**
     * Sets store in vault field.
     *
     * @param string|null $value
     */
    public function storeInVault(?string $value): self
    {
        $this->instance->setStoreInVault($value);
        return $this;
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets usage type field.
     *
     * @param string|null $value
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     *
     * @param string|null $value
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     *
     * @param bool|null $value
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Initializes a new Paypal Wallet Vault Base object.
     */
    public function build(): PaypalWalletVaultBase
    {
        return CoreHelper::clone($this->instance);
    }
}
