<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\MerchantPreferences;
use PaypalServerSdkLib\Models\PaymentPreferences;
use PaypalServerSdkLib\Models\PlanRequest;
use PaypalServerSdkLib\Models\SubscriptionBillingCycle;
use PaypalServerSdkLib\Models\Taxes;

/**
 * Builder for model PlanRequest
 *
 * @see PlanRequest
 */
class PlanRequestBuilder
{
    /**
     * @var PlanRequest
     */
    private $instance;

    private function __construct(PlanRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Plan Request Builder object.
     *
     * @param string $productId
     * @param string $name
     * @param SubscriptionBillingCycle[] $billingCycles
     * @param PaymentPreferences $paymentPreferences
     */
    public static function init(
        string $productId,
        string $name,
        array $billingCycles,
        PaymentPreferences $paymentPreferences
    ): self {
        return new self(new PlanRequest($productId, $name, $billingCycles, $paymentPreferences));
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets merchant preferences field.
     *
     * @param MerchantPreferences|null $value
     */
    public function merchantPreferences(?MerchantPreferences $value): self
    {
        $this->instance->setMerchantPreferences($value);
        return $this;
    }

    /**
     * Sets taxes field.
     *
     * @param Taxes|null $value
     */
    public function taxes(?Taxes $value): self
    {
        $this->instance->setTaxes($value);
        return $this;
    }

    /**
     * Sets quantity supported field.
     *
     * @param bool|null $value
     */
    public function quantitySupported(?bool $value): self
    {
        $this->instance->setQuantitySupported($value);
        return $this;
    }

    /**
     * Initializes a new Plan Request object.
     */
    public function build(): PlanRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
