<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\RefundPaymentInstruction;
use PaypalServerSdkLib\Models\RefundRequest;

/**
 * Builder for model RefundRequest
 *
 * @see RefundRequest
 */
class RefundRequestBuilder
{
    /**
     * @var RefundRequest
     */
    private $instance;

    private function __construct(RefundRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Refund Request Builder object.
     */
    public static function init(): self
    {
        return new self(new RefundRequest());
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets custom id field.
     *
     * @param string|null $value
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets invoice id field.
     *
     * @param string|null $value
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets note to payer field.
     *
     * @param string|null $value
     */
    public function noteToPayer(?string $value): self
    {
        $this->instance->setNoteToPayer($value);
        return $this;
    }

    /**
     * Sets payment instruction field.
     *
     * @param RefundPaymentInstruction|null $value
     */
    public function paymentInstruction(?RefundPaymentInstruction $value): self
    {
        $this->instance->setPaymentInstruction($value);
        return $this;
    }

    /**
     * Initializes a new Refund Request object.
     */
    public function build(): RefundRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
