<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaypalPaymentToken;
use PaypalServerSdkLib\Models\SetupTokenResponseCard;
use PaypalServerSdkLib\Models\SetupTokenResponsePaymentSource;
use PaypalServerSdkLib\Models\VenmoPaymentToken;

/**
 * Builder for model SetupTokenResponsePaymentSource
 *
 * @see SetupTokenResponsePaymentSource
 */
class SetupTokenResponsePaymentSourceBuilder
{
    /**
     * @var SetupTokenResponsePaymentSource
     */
    private $instance;

    private function __construct(SetupTokenResponsePaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Setup Token Response Payment Source Builder object.
     */
    public static function init(): self
    {
        return new self(new SetupTokenResponsePaymentSource());
    }

    /**
     * Sets card field.
     *
     * @param SetupTokenResponseCard|null $value
     */
    public function card(?SetupTokenResponseCard $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets paypal field.
     *
     * @param PaypalPaymentToken|null $value
     */
    public function paypal(?PaypalPaymentToken $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets venmo field.
     *
     * @param VenmoPaymentToken|null $value
     */
    public function venmo(?VenmoPaymentToken $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Initializes a new Setup Token Response Payment Source object.
     */
    public function build(): SetupTokenResponsePaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
