<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The frequency of the billing cycle.
 */
class Frequency implements \JsonSerializable
{
    /**
     * @var string
     */
    private $intervalUnit;

    /**
     * @var int|null
     */
    private $intervalCount = 1;

    /**
     * @param string $intervalUnit
     */
    public function __construct(string $intervalUnit)
    {
        $this->intervalUnit = $intervalUnit;
    }

    /**
     * Returns Interval Unit.
     * The interval at which the subscription is charged or billed.
     */
    public function getIntervalUnit(): string
    {
        return $this->intervalUnit;
    }

    /**
     * Sets Interval Unit.
     * The interval at which the subscription is charged or billed.
     *
     * @required
     * @maps interval_unit
     */
    public function setIntervalUnit(string $intervalUnit): void
    {
        $this->intervalUnit = $intervalUnit;
    }

    /**
     * Returns Interval Count.
     * The number of intervals after which a subscriber is billed. For example, if the `interval_unit` is
     * `DAY` with an `interval_count` of  `2`, the subscription is billed once every two days. The
     * following table lists the maximum allowed values for the `interval_count` for each `interval_unit`:
     * Interval unit Maximum interval count DAY 365 WEEK 52 MONTH 12 YEAR 1
     */
    public function getIntervalCount(): ?int
    {
        return $this->intervalCount;
    }

    /**
     * Sets Interval Count.
     * The number of intervals after which a subscriber is billed. For example, if the `interval_unit` is
     * `DAY` with an `interval_count` of  `2`, the subscription is billed once every two days. The
     * following table lists the maximum allowed values for the `interval_count` for each `interval_unit`:
     * Interval unit Maximum interval count DAY 365 WEEK 52 MONTH 12 YEAR 1
     *
     * @maps interval_count
     */
    public function setIntervalCount(?int $intervalCount): void
    {
        $this->intervalCount = $intervalCount;
    }

    /**
     * Converts the Frequency object to a human-readable string representation.
     *
     * @return string The string representation of the Frequency object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'Frequency',
            ['intervalUnit' => $this->intervalUnit, 'intervalCount' => $this->intervalCount]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['interval_unit']      = $this->intervalUnit;
        if (isset($this->intervalCount)) {
            $json['interval_count'] = $this->intervalCount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
