<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The payer information.
 */
class PayerInformation implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $accountId;

    /**
     * @var string|null
     */
    private $emailAddress;

    /**
     * @var Phone|null
     */
    private $phoneNumber;

    /**
     * @var string|null
     */
    private $addressStatus;

    /**
     * @var string|null
     */
    private $payerStatus;

    /**
     * @var PayerName|null
     */
    private $payerName;

    /**
     * @var string|null
     */
    private $countryCode;

    /**
     * @var SimplePostalAddressCoarseGrained|null
     */
    private $address;

    /**
     * Returns Account Id.
     * The PayPal` customer account ID.
     */
    public function getAccountId(): ?string
    {
        return $this->accountId;
    }

    /**
     * Sets Account Id.
     * The PayPal` customer account ID.
     *
     * @maps account_id
     */
    public function setAccountId(?string $accountId): void
    {
        $this->accountId = $accountId;
    }

    /**
     * Returns Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getEmailAddress(): ?string
    {
        return $this->emailAddress;
    }

    /**
     * Sets Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps email_address
     */
    public function setEmailAddress(?string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    /**
     * Returns Phone Number.
     * The phone number, in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     */
    public function getPhoneNumber(): ?Phone
    {
        return $this->phoneNumber;
    }

    /**
     * Sets Phone Number.
     * The phone number, in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     *
     * @maps phone_number
     */
    public function setPhoneNumber(?Phone $phoneNumber): void
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * Returns Address Status.
     * The address status of the payer. Value is either: Y. Verified. N. Not verified.
     */
    public function getAddressStatus(): ?string
    {
        return $this->addressStatus;
    }

    /**
     * Sets Address Status.
     * The address status of the payer. Value is either: Y. Verified. N. Not verified.
     *
     * @maps address_status
     */
    public function setAddressStatus(?string $addressStatus): void
    {
        $this->addressStatus = $addressStatus;
    }

    /**
     * Returns Payer Status.
     * The status of the payer. Value is `Y` or `N`.
     */
    public function getPayerStatus(): ?string
    {
        return $this->payerStatus;
    }

    /**
     * Sets Payer Status.
     * The status of the payer. Value is `Y` or `N`.
     *
     * @maps payer_status
     */
    public function setPayerStatus(?string $payerStatus): void
    {
        $this->payerStatus = $payerStatus;
    }

    /**
     * Returns Payer Name.
     * The name of the party.
     */
    public function getPayerName(): ?PayerName
    {
        return $this->payerName;
    }

    /**
     * Sets Payer Name.
     * The name of the party.
     *
     * @maps payer_name
     */
    public function setPayerName(?PayerName $payerName): void
    {
        $this->payerName = $payerName;
    }

    /**
     * Returns Country Code.
     * The [two-character ISO 3166-1 code](/docs/integration/direct/rest/country-codes/) that identifies
     * the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-
     * level domain names for that country. Use the `C2` country code for China worldwide for comparable
     * uncontrolled price (CUP) method, bank card, and cross-border transactions.
     */
    public function getCountryCode(): ?string
    {
        return $this->countryCode;
    }

    /**
     * Sets Country Code.
     * The [two-character ISO 3166-1 code](/docs/integration/direct/rest/country-codes/) that identifies
     * the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-
     * level domain names for that country. Use the `C2` country code for China worldwide for comparable
     * uncontrolled price (CUP) method, bank card, and cross-border transactions.
     *
     * @maps country_code
     */
    public function setCountryCode(?string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     */
    public function getAddress(): ?SimplePostalAddressCoarseGrained
    {
        return $this->address;
    }

    /**
     * Sets Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     *
     * @maps address
     */
    public function setAddress(?SimplePostalAddressCoarseGrained $address): void
    {
        $this->address = $address;
    }

    /**
     * Converts the PayerInformation object to a human-readable string representation.
     *
     * @return string The string representation of the PayerInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PayerInformation',
            [
                'accountId' => $this->accountId,
                'emailAddress' => $this->emailAddress,
                'phoneNumber' => $this->phoneNumber,
                'addressStatus' => $this->addressStatus,
                'payerStatus' => $this->payerStatus,
                'payerName' => $this->payerName,
                'countryCode' => $this->countryCode,
                'address' => $this->address
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->accountId)) {
            $json['account_id']     = $this->accountId;
        }
        if (isset($this->emailAddress)) {
            $json['email_address']  = $this->emailAddress;
        }
        if (isset($this->phoneNumber)) {
            $json['phone_number']   = $this->phoneNumber;
        }
        if (isset($this->addressStatus)) {
            $json['address_status'] = $this->addressStatus;
        }
        if (isset($this->payerStatus)) {
            $json['payer_status']   = $this->payerStatus;
        }
        if (isset($this->payerName)) {
            $json['payer_name']     = $this->payerName;
        }
        if (isset($this->countryCode)) {
            $json['country_code']   = $this->countryCode;
        }
        if (isset($this->address)) {
            $json['address']        = $this->address;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
