<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The billing details for the subscription. If the subscription was or is active, these fields are
 * populated.
 */
class SubscriptionBillingInformation implements \JsonSerializable
{
    /**
     * @var Money
     */
    private $outstandingBalance;

    /**
     * @var CycleExecution[]|null
     */
    private $cycleExecutions;

    /**
     * @var LastPaymentDetails|null
     */
    private $lastPayment;

    /**
     * @var string|null
     */
    private $nextBillingTime;

    /**
     * @var string|null
     */
    private $finalPaymentTime;

    /**
     * @var int
     */
    private $failedPaymentsCount;

    /**
     * @var FailedPaymentDetails|null
     */
    private $lastFailedPayment;

    /**
     * @param Money $outstandingBalance
     * @param int $failedPaymentsCount
     */
    public function __construct(Money $outstandingBalance, int $failedPaymentsCount)
    {
        $this->outstandingBalance = $outstandingBalance;
        $this->failedPaymentsCount = $failedPaymentsCount;
    }

    /**
     * Returns Outstanding Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getOutstandingBalance(): Money
    {
        return $this->outstandingBalance;
    }

    /**
     * Sets Outstanding Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps outstanding_balance
     */
    public function setOutstandingBalance(Money $outstandingBalance): void
    {
        $this->outstandingBalance = $outstandingBalance;
    }

    /**
     * Returns Cycle Executions.
     * The trial and regular billing executions.
     *
     * @return CycleExecution[]|null
     */
    public function getCycleExecutions(): ?array
    {
        return $this->cycleExecutions;
    }

    /**
     * Sets Cycle Executions.
     * The trial and regular billing executions.
     *
     * @maps cycle_executions
     *
     * @param CycleExecution[]|null $cycleExecutions
     */
    public function setCycleExecutions(?array $cycleExecutions): void
    {
        $this->cycleExecutions = $cycleExecutions;
    }

    /**
     * Returns Last Payment.
     * The details for the last payment.
     */
    public function getLastPayment(): ?LastPaymentDetails
    {
        return $this->lastPayment;
    }

    /**
     * Sets Last Payment.
     * The details for the last payment.
     *
     * @maps last_payment
     */
    public function setLastPayment(?LastPaymentDetails $lastPayment): void
    {
        $this->lastPayment = $lastPayment;
    }

    /**
     * Returns Next Billing Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getNextBillingTime(): ?string
    {
        return $this->nextBillingTime;
    }

    /**
     * Sets Next Billing Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps next_billing_time
     */
    public function setNextBillingTime(?string $nextBillingTime): void
    {
        $this->nextBillingTime = $nextBillingTime;
    }

    /**
     * Returns Final Payment Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getFinalPaymentTime(): ?string
    {
        return $this->finalPaymentTime;
    }

    /**
     * Sets Final Payment Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps final_payment_time
     */
    public function setFinalPaymentTime(?string $finalPaymentTime): void
    {
        $this->finalPaymentTime = $finalPaymentTime;
    }

    /**
     * Returns Failed Payments Count.
     * The number of consecutive payment failures. Resets to `0` after a successful payment. If this
     * reaches the `payment_failure_threshold` value, the subscription updates to the `SUSPENDED` state.
     */
    public function getFailedPaymentsCount(): int
    {
        return $this->failedPaymentsCount;
    }

    /**
     * Sets Failed Payments Count.
     * The number of consecutive payment failures. Resets to `0` after a successful payment. If this
     * reaches the `payment_failure_threshold` value, the subscription updates to the `SUSPENDED` state.
     *
     * @required
     * @maps failed_payments_count
     */
    public function setFailedPaymentsCount(int $failedPaymentsCount): void
    {
        $this->failedPaymentsCount = $failedPaymentsCount;
    }

    /**
     * Returns Last Failed Payment.
     * The details for the failed payment of the subscription.
     */
    public function getLastFailedPayment(): ?FailedPaymentDetails
    {
        return $this->lastFailedPayment;
    }

    /**
     * Sets Last Failed Payment.
     * The details for the failed payment of the subscription.
     *
     * @maps last_failed_payment
     */
    public function setLastFailedPayment(?FailedPaymentDetails $lastFailedPayment): void
    {
        $this->lastFailedPayment = $lastFailedPayment;
    }

    /**
     * Converts the SubscriptionBillingInformation object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionBillingInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionBillingInformation',
            [
                'outstandingBalance' => $this->outstandingBalance,
                'cycleExecutions' => $this->cycleExecutions,
                'lastPayment' => $this->lastPayment,
                'nextBillingTime' => $this->nextBillingTime,
                'finalPaymentTime' => $this->finalPaymentTime,
                'failedPaymentsCount' => $this->failedPaymentsCount,
                'lastFailedPayment' => $this->lastFailedPayment
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['outstanding_balance']     = $this->outstandingBalance;
        if (isset($this->cycleExecutions)) {
            $json['cycle_executions']    = $this->cycleExecutions;
        }
        if (isset($this->lastPayment)) {
            $json['last_payment']        = $this->lastPayment;
        }
        if (isset($this->nextBillingTime)) {
            $json['next_billing_time']   = $this->nextBillingTime;
        }
        if (isset($this->finalPaymentTime)) {
            $json['final_payment_time']  = $this->finalPaymentTime;
        }
        $json['failed_payments_count']   = $this->failedPaymentsCount;
        if (isset($this->lastFailedPayment)) {
            $json['last_failed_payment'] = $this->lastFailedPayment;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
